// 防止重复声明的保护
if (typeof window.rtvtExtensionLoaded === 'undefined') {
    window.rtvtExtensionLoaded = true;

    var globalSeg = 0;
    var tabId = 0;
    var rtvtClient = null;
    var rtvtStream = null;
    var apiHost = "https://account-api.ilivedata.com/rtvtchrome/gettoken";
    var getUserInfoApiUrl = "https://rtvt-cn-app.ilivedata.com/service/account/get_user_info";
    var DONATE_ICON_UNPAID_URL = chrome.runtime.getURL('images/unpaid.png');
    var DONATE_ICON_VIP_URL = chrome.runtime.getURL('images/vip.png');
    var DONATE_TOOLTIP_UNPAID = "VIP";
    function formatVipExpireAt(timestamp) {
        if (timestamp == null || timestamp === undefined || timestamp <= 0) return "VIP";
        var ts = typeof timestamp === "number" ? timestamp : parseInt(timestamp, 10);
        if (isNaN(ts) || ts <= 0) return "VIP";
        var d = new Date(ts * 1000);
        var y = d.getFullYear();
        var m = String(d.getMonth() + 1).padStart(2, "0");
        var day = String(d.getDate()).padStart(2, "0");
        var h = String(d.getHours()).padStart(2, "0");
        var min = String(d.getMinutes()).padStart(2, "0");
        return "VIP：" + y + "-" + m + "-" + day;// + " " + h + ":" + min;
    }
    function setDonateIconUnpaid() {
        var btn = $('.rtvt-top-donate-link');
        var img = btn.find('.rtvt-top-donate-img');
        if (img.length) img.attr('src', DONATE_ICON_UNPAID_URL);
        if (btn.length) btn.attr('title', DONATE_TOOLTIP_UNPAID);
    }
    function setDonateIconVip(vipExpireAt) {
        var btn = $('.rtvt-top-donate-link');
        var img = btn.find('.rtvt-top-donate-img');
        if (img.length) img.attr('src', DONATE_ICON_VIP_URL);
        if (btn.length) btn.attr('title', formatVipExpireAt(vipExpireAt));
    }

    var globalLangs = {};
    var sizeSlider = null;
    var opacitySlider = null;

let PID = 0;
let g_streamID = "";

const initWidth = 800;
const initHeight = 180;
let mainMinWidth = 510;
const mainMinHeight = 180;
const scrollFactor = 10;
let isLoading = false;
let isLogin = false;
let hasPermission = false;
let isCapture = false;
let worker = null;
let isMoveing = false;

let hideMenuFlag = false; // 顶部菜单隐藏开关

let isFullDelayInit = false;
let hasRated = false; // 标记用户是否已经进行过点赞/点踩操作

var globalConfig = {
    asrLang: 'auto',
    altLang: 'en',
    textSize: 'size-l',
    textColor: 'white',
    containerWidth: initWidth,
    containerHeight: initHeight,
    containerTop: 0,
    containerLeft: 0,
    uid: "0",
    openSubtitle: 1,
    openBall: 1,
    textShadow: 'None',
    bgOpacity: 90,
    highlightCurrentTranslation: 0,
};

var loginToUseStr = chrome.i18n.getMessage("login_to_use") || '请登录后使用';

const logoBase64 = "data:image/png;base64,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";

const settingBase64 = "data:image/png;base64,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";

const helpBase64 = "data:image/png;base64,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";

const closeBase64 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAA8CAYAAAA6/NlyAAAAAXNSR0IArs4c6QAAAARzQklUCAgICHwIZIgAAAGnSURBVGiB7drhbcIwEIbhcydghIzACGUDRsgobMAIjNARGKHdgGxAO8HXH8RSaEnOcc4+27pXQqpoYt9D2j/IRJZlWZZlFRuADsAHgE8AR+15po2zXcdXJ7XoGc/1IgtvbMTeJnNdQ+57i9jroo0en+aViLrJ2zupxXd/PknVJ/3iyQLAHcA+9SbZ0VmwzGbZ0FmxzKbJ0SpYZvNkaFUsM4Q4uggsM4wYuigsM9RmdJFYZrhodNFYnxS6CqxvK7oqrC8WXSXWtxZdNdYXim4C6+PQTWF9C+hTc1jfAro9rI9Bt4X1AXifAZ+0ZxMv4M+6155RrMD/4TbQM9g7gOPMh9BrzxzdAna/8Ps60RyWua4udCiWub4O9Fosc1/Z6Fgsc3+Z6K1YZp2y0FJYZr0y0NJYZl1ddCoss74OOjWW2ScvOheW2S8POjeW2TctWgvL7J8GrY1l5pBFl4Jl5gGkjlTh/7El9e+gZtC3kHtDji39TH7+JqKDc+4ralKhnHMDER2IaJi8Pby6dnV4HFs643Ear6hvF8cnfRlfnfY8lmVZlmVZT/0CSirOJ1wldScAAAAASUVORK5CYII=";

const languageOrder = ["auto", "en", "ja", "zh", "ko", "th", "es", "ru", "fr", "de", "ar", "it", "pt", "tr", "id", "vi", "hi", "ms", "ph", "zh-yue"];

var ajaxRequest = function(url, type, data, timeout, option, retries = 2) {
    $.ajax({
        type: type,
        url: url,
        timeout: timeout,
        data: data,
        dataType: (option.dataType !== undefined) ? option.dataType : undefined,
        success: (option.success !== undefined) ? option.success : function(data){},
        complete: (option.complete !== undefined) ? option.complete : function(jqXHR, textStatus){},
        error: function(jqXHR, textStatus, errorThrown){
            if (retries > 0){
                retries--;
                setTimeout(ajaxRequest(url, type, data, timeout, option, retries), 100);
            } else if (option.error !== undefined){
                option.error(jqXHR, textStatus, errorThrown);
                isLoading = false;
                uploadLog("getToken", "get the token all failed");
            } 
        },
        beforeSend: (option.beforeSend !== undefined) ? option.beforeSend : function(jqXHR, settings){}
    });
};

var compile = function(functionObject) {
    return function (scope) {
        return functionObject.toString().match(/\/\*([\s\S]*?)\*\//)[1].replace(/\$\{\w.+\}/g, function (variable) {
            var value = scope;
            variable = variable.replace('${', '').replace('}', '');
            variable.split('.').forEach(function (section) {
                value = value[section];
            });
            return value;
        });
    }
};

// 根据用户 VIP 状态更新捐赠按钮图标（已登录时调用 get_user_info 接口）
function updateDonateIconByVipStatus(uid, token) {
    if (!$('.rtvt-top-donate-img').length) return;
    if (!uid || !token || (typeof uid === 'string' && uid.indexOf('-') !== -1)) {
        setDonateIconUnpaid();
        return;
    }
    var uidStr = typeof uid === 'number' ? String(uid) : uid;
    var tokenStr = typeof token === 'string' ? token : (token && token.token ? token.token : '');
    if (!tokenStr) {
        setDonateIconUnpaid();
        return;
    }
    var body = JSON.stringify({
        uid: uidStr,
        token: tokenStr,
        product: "rtvt",
        platform: "chrome",
        deviceId: ""
    });
    ajaxRequest(getUserInfoApiUrl, 'post', body, 5000, {
        dataType: 'json',
        beforeSend: function(xhr) { xhr.setRequestHeader('Content-Type', 'application/json'); },
        success: function(data) {
            if (data && data.code === 0 && data.data && data.data.isVip === true) {
                setDonateIconVip(data.data.vipExpireAt);
            } else {
                setDonateIconUnpaid();
            }
        },
        error: function() { setDonateIconUnpaid(); }
    });
}

var saveContainerPosition = function() {
    globalConfig.containerWidth = $('#rtvt-main-container').width();
    globalConfig.containerHeight = $('#rtvt-main-container').height();
    globalConfig.containerTop = $('#rtvt-main-container').offset().top - $(window).scrollTop();
    globalConfig.containerLeft = $('#rtvt-main-container').offset().left - $(window).scrollLeft();

    chrome.storage.local.set({ containerWidth : globalConfig.containerWidth }).then(() => {});
    chrome.storage.local.set({ containerHeight : globalConfig.containerHeight }).then(() => {});
    chrome.storage.local.set({ containerTop : globalConfig.containerTop }).then(() => {});
    chrome.storage.local.set({ containerLeft : globalConfig.containerLeft }).then(() => {});
};

var helpCardShow = function() {
    if ($('.help-card').hasClass('card-hidden')) {
        $('.help-card').removeClass('card-hidden');
    } else {
        $('.help-card').addClass('card-hidden');
    }
};

var loginRequiredCardShow = function() {
    if ($('.login-required-card').hasClass('card-hidden')) {
        console.log("loginRequiredCardShow1");
        $('.login-required-card').removeClass('card-hidden');
    } 
};

var loginRequiredCardHide = function() {
    $('.login-required-card').addClass('card-hidden');
};

// 显示点赞点踩模态框
var showRatingModal = function() {
    $('#rating-modal').removeClass('card-hidden');
    
    // 如果用户已经进行过点赞/点踩操作，显示"暂停中"状态
    if (hasRated) {
        // 显示页面1，隐藏页面2
        $('#rating-page').removeClass('card-hidden');
        $('#feedback-page').addClass('card-hidden');
        // 设置标题为"暂停中"
        $('.rating-modal-title').text(chrome.i18n.getMessage("pausing"));
        // 显示暂停图标
        $('#pausing-icon').removeClass('card-hidden').show();
        // 隐藏点赞点踩按钮容器和按钮元素（使用多种方法确保隐藏）
        $('.rating-buttons').addClass('card-hidden').hide();
        $('#rating-like').addClass('card-hidden').hide();
        $('#rating-dislike').addClass('card-hidden').hide();
    } else {
        // 显示页面1，隐藏页面2
        showRatingPage();
        // 隐藏暂停图标
        $('#pausing-icon').addClass('card-hidden').hide();
    }
};

// 显示评分页面（页面1）
var showRatingPage = function() {
    $('#rating-page').removeClass('card-hidden');
    $('#feedback-page').addClass('card-hidden');
    // 重置图标状态（如果用户没有完成点踩流程就返回）
    $('#rating-like .rating-icon-like path').attr('fill', '#3D3D3D');
    $('#rating-dislike .rating-icon-dislike path').attr('fill', '#3D3D3D');
    $('.rating-btn').removeClass('selected');
    // 重置标题文字
    $('.rating-modal-title').text(chrome.i18n.getMessage("rating_title"));
    // 如果用户已经进行过点赞/点踩操作，隐藏按钮并显示暂停图标；否则显示按钮并隐藏暂停图标
    if (hasRated) {
        $('.rating-buttons').addClass('card-hidden').hide();
        $('#rating-like').addClass('card-hidden').hide();
        $('#rating-dislike').addClass('card-hidden').hide();
        $('#pausing-icon').removeClass('card-hidden').show();
    } else {
        $('.rating-buttons').removeClass('card-hidden').show();
        $('#rating-like').removeClass('card-hidden').show();
        $('#rating-dislike').removeClass('card-hidden').show();
        $('#pausing-icon').addClass('card-hidden').hide();
    }
};

// 显示反馈页面（页面2）
var showFeedbackPage = function() {
    $('#rating-page').addClass('card-hidden');
    $('#feedback-page').removeClass('card-hidden');
    // 重置反馈表单
    $('#feedback-select').val('');
    $('#feedback-other-input').addClass('card-hidden').val('');
    // 初始化提交按钮为禁用状态
    $('#feedback-submit').prop('disabled', true);
};

// 隐藏点赞点踩模态框
var hideRatingModal = function() {
    $('#rating-modal').addClass('card-hidden');
    // 重置到页面1
    showRatingPage();
    // 重置标题文字
    $('.rating-modal-title').text(chrome.i18n.getMessage("rating_title"));
    // 确保按钮显示（为下次显示做准备）
    $('.rating-buttons').removeClass('card-hidden');
    $('#rating-like').removeClass('card-hidden');
    $('#rating-dislike').removeClass('card-hidden');
    // 隐藏暂停图标
    $('#pausing-icon').addClass('card-hidden').hide();
};

// 处理点赞点踩点击
var handleRatingClick = function(isLike) {
    // 检查用户登录状态
    if (!isLogin) {
        // 未登录，跳转到登录页面
        sendLoginQuest();
        return;
    }
    
    // 移除所有选中状态
    $('.rating-btn').removeClass('selected');
    
    // 添加选中状态到被点击的按钮，并改变图标颜色
    if (isLike) {
        // 点赞立即完成
        hasRated = true;

        let data = {
            pid: PID.toString(), 
            streamId: g_streamID,
            userId: globalConfig.uid.toString(), 
            command: 0,
            ts: Math.floor(Date.now() / 1000).toString(), 
            srcLang: globalConfig.asrLang["key"],
            targetLang: globalConfig.altLang["key"],
            platform: "extension_" + getBrowserInfo(),
            function: "extensionTranslate"
        }

        feedback_function(data);
        uploadLog("feedback", "feedback submit, type: " + data.command);
        
        $('#rating-like').addClass('selected');
        // 将点赞图标改为紫色
        $('#rating-like .rating-icon-like path').attr('fill', '#936FFF');
        // 重置点踩图标为灰色
        $('#rating-dislike .rating-icon-dislike path').attr('fill', '#3D3D3D');
        
        // 点赞成功，显示成功信息并关闭
        $('.rating-modal-title').text(chrome.i18n.getMessage("rating_success"));
        
        // 1秒后关闭模态框
        setTimeout(function() {
            hideRatingModal();
        }, 1000);
    } else {
        // 点踩暂时不设置hasRated，等待用户提交反馈
        $('#rating-dislike').addClass('selected');
        // 将点踩图标改为紫色
        $('#rating-dislike .rating-icon-dislike path').attr('fill', '#936FFF');
        // 重置点赞图标为灰色
        $('#rating-like .rating-icon-like path').attr('fill', '#3D3D3D');
        
        // 短暂延迟后切换到反馈页面
        setTimeout(function() {
            showFeedbackPage();
        }, 100);
    }
};

// 通用提示函数：在目标元素中心显示提示并自动消失（可选：手动关闭）
// manualClose=true 时：显示关闭按钮，且不再自动消失（用户手动关闭）
function removeAllToasts() {
    try {
        // 清理单例 toast 的定时器（避免残留回调）
        if (typeof window !== 'undefined' && window.__rtvtToastState) {
            try {
                if (window.__rtvtToastState.autoCloseTimerId) {
                    clearTimeout(window.__rtvtToastState.autoCloseTimerId);
                }
                if (window.__rtvtToastState.removeTimerId) {
                    clearTimeout(window.__rtvtToastState.removeTimerId);
                }
                if (window.__rtvtToastState.countdownIntervalId) {
                    clearInterval(window.__rtvtToastState.countdownIntervalId);
                }
            } catch (e) { }
            try { window.__rtvtToastState = null; } catch (e) { }
        }

        document.querySelectorAll('.rtvt-download-toast').forEach((el) => {
            try { el.remove(); } catch (e) { }
        });
    } catch (e) { }
}

// showCountdown=true 时：自动倒计时关闭 + 支持手动关闭，并展示倒计时数字
function showToast(message, duration = 1000, targetSelector = '#rtvt-content', manualClose = false, showCountdown = false) {
    try {
        // 始终只允许存在一个 toast：新 toast 出现前先关掉旧 toast
        removeAllToasts();

        const target = document.querySelector(targetSelector) || document.body;
        const rect = target.getBoundingClientRect();

        const toast = document.createElement('div');
        const enableManualClose = !!manualClose || !!showCountdown;
        toast.className = 'rtvt-download-toast' + (enableManualClose ? ' rtvt-download-toast--closable' : '');
        toast.style.position = 'fixed';
        toast.style.left = (rect.left + rect.width / 2) + 'px';
        // 往上挪一点，避免挡住正中心；并做边界保护
        const topPx = (rect.top + rect.height / 2) - 30;
        toast.style.top = Math.max(20, topPx) + 'px';
        toast.style.transform = 'translate(-50%, -50%)';
        toast.style.opacity = '1';

        const msgSpan = document.createElement('span');
        msgSpan.className = 'rtvt-download-toast-msg';
        msgSpan.textContent = message;
        toast.appendChild(msgSpan);

        // 单例状态：用于清理定时器/防止叠加
        const toastState = {
            toast,
            autoCloseTimerId: null,
            removeTimerId: null,
            countdownIntervalId: null
        };
        if (typeof window !== 'undefined') {
            window.__rtvtToastState = toastState;
        }

        let removed = false;
        const closeToast = () => {
            if (removed) return;
            removed = true;
            try {
                // 关闭时清理可能存在的定时器
                if (toastState.autoCloseTimerId) {
                    clearTimeout(toastState.autoCloseTimerId);
                    toastState.autoCloseTimerId = null;
                }
                if (toastState.removeTimerId) {
                    clearTimeout(toastState.removeTimerId);
                    toastState.removeTimerId = null;
                }
                if (toastState.countdownIntervalId) {
                    clearInterval(toastState.countdownIntervalId);
                    toastState.countdownIntervalId = null;
                }

                toast.style.transition = 'opacity 0.3s';
                toast.style.opacity = '0';
                toastState.removeTimerId = setTimeout(() => {
                    try { toast.remove(); } catch (e) { }
                    try {
                        if (typeof window !== 'undefined' && window.__rtvtToastState && window.__rtvtToastState.toast === toast) {
                            window.__rtvtToastState = null;
                        }
                    } catch (e2) { }
                }, 300);
            } catch (e) {
                try { toast.remove(); } catch (e2) { }
            }
        };

        // 倒计时显示（仅 showCountdown=true 时开启）
        let countdownSpan = null;
        if (showCountdown) {
            countdownSpan = document.createElement('span');
            countdownSpan.className = 'rtvt-download-toast-countdown';
            toast.appendChild(countdownSpan);
        }

        if (enableManualClose) {
            const closeBtn = document.createElement('button');
            closeBtn.type = 'button';
            closeBtn.className = 'rtvt-download-toast-close';
            closeBtn.setAttribute('aria-label', 'Close');
            closeBtn.textContent = '×';
            closeBtn.addEventListener('click', (e) => {
                try { e.preventDefault(); e.stopPropagation(); } catch (err) { }
                closeToast();
            });
            toast.appendChild(closeBtn);
        }

        // 自动关闭逻辑：
        // - 默认（manualClose=false 且 showCountdown=false）：自动关闭
        // - manualClose=true 且 showCountdown=false：仅手动关闭（不自动）
        // - showCountdown=true：自动关闭 + 可手动关闭 + 显示倒计时
        if (!manualClose || showCountdown) {
            const safeDuration = Math.max(0, Number(duration) || 0);
            if (showCountdown && countdownSpan) {
                const endAt = Date.now() + safeDuration;
                const renderCountdown = () => {
                    const remainMs = endAt - Date.now();
                    const remainSec = Math.max(0, Math.ceil(remainMs / 1000));
                    countdownSpan.textContent = remainSec + 's';
                };
                renderCountdown();
                toastState.countdownIntervalId = setInterval(renderCountdown, 250);
            }
            toastState.autoCloseTimerId = setTimeout(() => closeToast(), safeDuration);
        }

        document.body.appendChild(toast);
    } catch (e) {
        console.error('showToast error', e);
    }
}


// 在initPage函数中添加计算高度的函数
function updateContentHeight() {
    const topMenuHeight = $('#rtvt-top-menu').outerHeight();
    
    // 设置内容区域高度
    $('#rtvt-content').css({
        'height': `calc(100% - ${topMenuHeight + 1}px)`,
        'overflow-y': 'auto'
    });
}

let isRestart2 = false;
function workerOnmessage(data) {
    if (data.cmd == 'ErrorRecorder') {
        console.log(data.errorCode);
        if (data.errorCode == 800002 && !isRestart2) {
            isRestart2 = true;
            //console.log("restart rtvt client");
            pauseRecording(data.tabId);
            setTimeout(() => {
                //console.log("resume rtvt client1");
                resumeRecording(data.tabId);
                isRestart2 = false;
            }, 1000);
        }
    }
    else if (data.cmd == 'recognizedResult') {
        hasPermission = true;
        $('.no-permission-div').hide();
        let autoScroll = true;
        if ($('#rtvt-content').scrollTop() + $('#rtvt-content').height() + 40 + scrollFactor < $('#rtvt-content').prop('scrollHeight')) {
            autoScroll = false;
        }

        if ($('#rtvt-result-' + data.data.streamId + '-' + data.data.taskId).length == 0) {
            $('.rtvt-tmp-result').attr('id', 'rtvt-result-' + data.data.streamId + '-' + data.data.taskId);
            $('#rtvt-result-' + data.data.streamId + '-' + data.data.taskId).removeClass('rtvt-tmp-result');

            $('#rtvt-content').append('<div class="rtvt-result-div rtvt-tmp-result"><div class="rtvt-asr-result"></div><div class="rtvt-alt-result"></div></div>');
        }

        if (globalConfig.openSubtitle == 1) {
            $('#rtvt-result-' + data.data.streamId + '-' + data.data.taskId).find('.rtvt-asr-result').text(data.data.asr);
        }

        // 翻译完成时移除高亮样式
        $('#rtvt-result-' + data.data.streamId + '-' + data.data.taskId).find('.rtvt-asr-result').removeClass('size-xxl');
        
        if (autoScroll) {
            $('#rtvt-content').scrollTop($('#rtvt-content')[0].scrollHeight);
        }
    }
    else if (data.cmd == 'recognizedTempResult') {
        hasPermission = true;
        $('.no-permission-div').hide();
        let autoScroll = true;
        if ($('#rtvt-content').scrollTop() + $('#rtvt-content').height() + 40 + scrollFactor < $('#rtvt-content').prop('scrollHeight')) {
            autoScroll = false;
        }

        if ($('.rtvt-tmp-result').length == 0) {
            $('#rtvt-content').append('<div class="rtvt-result-div rtvt-tmp-result"><div class="rtvt-asr-result"></div><div class="rtvt-alt-result"></div></div>');
        }

        if (globalConfig.openSubtitle == 1) {
            $('.rtvt-tmp-result').find('.rtvt-asr-result').text(data.data.asr);
        }

        // 高亮当前翻译：如果开关打开，添加样式
        if (globalConfig.highlightCurrentTranslation == 1 || globalConfig.highlightCurrentTranslation == '1') {
            $('.rtvt-tmp-result').find('.rtvt-asr-result').addClass('size-xxl');
        }

        if (autoScroll) {
            $('#rtvt-content').scrollTop($('#rtvt-content')[0].scrollHeight);
        }
    }
    else if (data.cmd == 'translatedResult') {
        hasPermission = true;
        $('.no-permission-div').hide();
        let autoScroll = true;
        if ($('#rtvt-content').scrollTop() + $('#rtvt-content').height() + 40 + scrollFactor < $('#rtvt-content').prop('scrollHeight')) {
            autoScroll = false;
        }
        
        $('#rtvt-result-' + data.data.streamId + '-' + data.data.taskId).find('.rtvt-alt-result').text(data.data.trans);
        
        // 翻译完成时移除高亮样式
        $('#rtvt-result-' + data.data.streamId + '-' + data.data.taskId).find('.rtvt-alt-result').removeClass('size-xxl');

        if (autoScroll) {
            $('#rtvt-content').scrollTop($('#rtvt-content')[0].scrollHeight);
        }
    }
    else if (data.cmd == 'translatedTempResult') {
        $('.no-permission-div').hide();
        hasPermission = true;
        let autoScroll = true;
        if ($('#rtvt-content').scrollTop() + $('#rtvt-content').height() + 40 + scrollFactor < $('#rtvt-content').prop('scrollHeight')) {
            autoScroll = false;
        }

        if (globalConfig.openSubtitle == 1 && $('.rtvt-tmp-result').find('.rtvt-asr-result').text().length > 0) {
            $('.rtvt-tmp-result').find('.rtvt-alt-result').text(data.data.trans);
        } else if (globalConfig.openSubtitle == 0) {
            $('.rtvt-tmp-result').find('.rtvt-alt-result').text(data.data.trans);
        }

        // 高亮当前翻译：如果开关打开，添加样式
        if (globalConfig.highlightCurrentTranslation == 1 || globalConfig.highlightCurrentTranslation == '1') {
            $('.rtvt-tmp-result').find('.rtvt-alt-result').addClass('size-xxl');
        }

        if (autoScroll) {
            $('#rtvt-content').scrollTop($('#rtvt-content')[0].scrollHeight);
        }
    }
    else if (data.cmd == 'log') {
        uploadLog(data.data.event_id, data.data.log);
    }
    else if (data.cmd == 'loginResult') {
        console.log('Login result:', data.data);
    }
    else if (data.cmd == 'createStream') {
        console.log('Create stream result:', data.data);
        g_streamID = data.data.id;
    }
}

async function initWorker() {
    if (worker === null) {
        try {
            const workerURL = chrome.runtime.getURL('worker.js');
            const int64URL = chrome.runtime.getURL('thirdParty/int64.min.js');
            const fpnnURL = chrome.runtime.getURL('thirdParty/fpnn.min.js');
            const sdkURL = chrome.runtime.getURL('thirdParty/rtvt.sdk.js');
            const msgURL = chrome.runtime.getURL('thirdParty/msgpack.min.js');
            // 读取脚本内容
            const scripts = await Promise.all([
                fetch(int64URL).then(r => r.text()),
                fetch(msgURL).then(r => r.text()),
                fetch(fpnnURL).then(r => r.text()),
                fetch(sdkURL).then(r => r.text()),
                fetch(workerURL).then(r => r.text())
            ]);

            // 合并所有脚本
            const workerCode = `
                self.window = self;
                self.global = self;
                
                // Int64 implementation
                ${scripts[0]}
                
                // Msgpack implementation  
                ${scripts[1]}
                
                // FPNN implementation
                ${scripts[2]}
                
                // SDK implementation
                ${scripts[3]}
                
                // Worker implementation
                ${scripts[4]}
            `;

            // 创建blob URL
            const blob = new Blob([workerCode], { type: 'text/javascript' });
            const blobURL = URL.createObjectURL(blob);
            
            // 创建worker
            worker = new Worker(blobURL);
            URL.revokeObjectURL(blobURL); // 清理 blob URL

            worker.onmessage = function(e) {
                // console.log('----Worker message:', e.data);
                workerOnmessage(e.data);
            }
        } catch (e) {
            console.error('Failed to create worker:', e);
        }
    }
}

// 更新登录按钮tooltip的函数
function updateLoginTooltip() {
    // 使用setTimeout确保DOM已完全渲染
    setTimeout(function() {
        if (isLogin) {
            // 已登录时移除tooltip
            $('.rtvt-top-login-link').removeAttr('data-tooltip');
            $('.menu-user-login').removeAttr('data-tooltip');
        } else {
            // 未登录时显示登录提示
            var loginTooltipStr = chrome.i18n.getMessage("login_tooltip");
            var tooltipText = loginTooltipStr || '点击登录以使用完整功能';
            
            // 只设置data-tooltip属性，使用自定义tooltip
            $('.rtvt-top-login-link').attr('data-tooltip', tooltipText);
            //$('.rtvt-top-login-link').attr('title', tooltipText);
            $('.menu-user-login').attr('data-tooltip', tooltipText);
            
            var topLoginBtn = document.querySelector('.rtvt-top-login-link');
            var menuLoginBtn = document.querySelector('.menu-user-login');
            
            if (topLoginBtn) {
                topLoginBtn.setAttribute('data-tooltip', tooltipText);
            }
            if (menuLoginBtn) {
                menuLoginBtn.setAttribute('data-tooltip', tooltipText);
            }
        }
    }, 200); // 增加延迟时间确保DOM完全加载
}

var initPage = function() {
    var stopTransStr = chrome.i18n.getMessage("stoptrans");
    var settingsStr = chrome.i18n.getMessage("settings");
    var recoglangStr = chrome.i18n.getMessage("recoglang");
    var subtitlesStr = chrome.i18n.getMessage("subtitles");
    var translangStr = chrome.i18n.getMessage("translang");
    var subtitlesStyleStr = chrome.i18n.getMessage("subtitles_style");
    var fontColorStr = chrome.i18n.getMessage("font_color");
    var fontSizeStr = chrome.i18n.getMessage("font_size");
    var smallStr = chrome.i18n.getMessage("small");
    var mediumStr = chrome.i18n.getMessage("medium");
    var largeStr = chrome.i18n.getMessage("large");
    var closeStr = chrome.i18n.getMessage("close");
    var guide1 = chrome.i18n.getMessage("guide1");
    var guide2 = chrome.i18n.getMessage("guide2");
    var guide3 = chrome.i18n.getMessage("guide3");
    var guide4 = chrome.i18n.getMessage("guide4");
    var guide5 = chrome.i18n.getMessage("guide5");
    var guide6 = chrome.i18n.getMessage("guide6");
    var guide7 = chrome.i18n.getMessage("guide7");
    var guide8 = chrome.i18n.getMessage("guide8");
    var guide9 = chrome.i18n.getMessage("guide9");
    var moreStr = chrome.i18n.getMessage("more");
    var floatballStr = chrome.i18n.getMessage("floatball");
    var floatballdescStr = chrome.i18n.getMessage("floatballdesc");
    var demotextStr = chrome.i18n.getMessage("demotext");
    var noPermissionTitle1Str = chrome.i18n.getMessage("noPermission1");
    var noPermissionTitle2Str = chrome.i18n.getMessage("noPermission2");
    var tutorialStr = chrome.i18n.getMessage("tutorial");
    var userfeedback = chrome.i18n.getMessage("user_feedback");
    var textStroke = chrome.i18n.getMessage("textStroke");
    var strokeNone = chrome.i18n.getMessage("strokeNone");
    var strokeBlack = chrome.i18n.getMessage("strokeBlack");
    var strokeWhite = chrome.i18n.getMessage("strokeWhite");
    var loginRequiredDescStr = chrome.i18n.getMessage("login_required_desc");
    var loginNowStr = chrome.i18n.getMessage("login_now");
    var backgroundOpacityStr = chrome.i18n.getMessage("background_opacity");
    var login_status = chrome.i18n.getMessage("login_status");
    var highlightCurrentTranslationStr = chrome.i18n.getMessage("highlight_translation");
    var loginTextStr = chrome.i18n.getMessage("login");
    var downloadSubtitleStr = chrome.i18n.getMessage("donwload_subtitle");
    var ratingTitleStr = chrome.i18n.getMessage("rating_title");
    var feedbackSelectPlaceholderStr = chrome.i18n.getMessage("feedback_select_placeholder");
    var donateStr = chrome.i18n.getMessage("donate");
    var donateIconUrlUnpaid = DONATE_ICON_UNPAID_URL;
    var donateBtnTitleStr = DONATE_TOOLTIP_UNPAID;
    var feedbackOptionSubtitleMissingStr = chrome.i18n.getMessage("feedback_option_subtitle_missing");
    var feedbackOptionTranslationNoResultStr = chrome.i18n.getMessage("feedback_option_translation_no_result");
    var feedbackOptionRecognitionInaccuracyStr = chrome.i18n.getMessage("feedback_option_recognition_inaccuracy");
    var feedbackOptionTranslationInaccuracyStr = chrome.i18n.getMessage("feedback_option_translation_inaccuracy");
    var feedbackOptionNetworkErrorStr = chrome.i18n.getMessage("feedback_option_network_error");
    var feedbackOptionSubtitleFastStr = chrome.i18n.getMessage("feedback_option_subtitle_fast");
    var feedbackOptionLanguageMissingStr = chrome.i18n.getMessage("feedback_option_language_missing");
    var feedbackOptionOtherStr = chrome.i18n.getMessage("feedback_option_other");
    var feedbackOtherPlaceholderStr = chrome.i18n.getMessage("feedback_other_placeholder");
    var feedbackSubmitBtnStr = chrome.i18n.getMessage("feedback_submit_btn");
    var feedbackReturnBtnStr = chrome.i18n.getMessage("feedback_return_btn");
    var feedbackSuccessMessageStr = chrome.i18n.getMessage("feedback_success_message");
    const containerHtml = compile(function() {/*
        <div id="rtvt-main-container">
            <div id="rtvt-top-menu" class="rtvt-top-menu-hidden-x">
                <div id="rtvt-top-logo">
                </div>
                
                <button id="rtvt-pause-btn" val="play">${stopTransStr}</button>
                
                <div class="rtvt-top-center">
                    <button id="src-lang-btn" val="play"></button>
                    <span id="arrow-right">&#8594;</span>
                    <button id="dst-lang-btn" val="play"></button>
                </div>

                <div id="rtvt-top-copy-btn" class="rtvt-top-copy-btn">
                    <button role="button" class="rtvt-top-donate-link" title="${donateBtnTitleStr}">
                        <img class="rtvt-top-donate-img" src="${donateIconUrlUnpaid}" alt="donate">
                    </button>
                    <button role="button" class="rtvt-top-copy-link" title="${downloadSubtitleStr}">
                        <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M7.71572 22L7.46429 21.9921C6.50543 21.9283 5.60669 21.5024 4.95016 20.8007C4.29364 20.0989 3.92844 19.1738 3.92857 18.2129V17.2857H3.14286C2.30932 17.2857 1.50992 16.9546 0.920523 16.3652C0.331123 15.7758 0 14.9764 0 14.1429V3.14286C0 2.30932 0.331123 1.50992 0.920523 0.920523C1.50992 0.331123 2.30932 0 3.14286 0H14.1429C14.9764 0 15.7758 0.331123 16.3652 0.920523C16.9546 1.50992 17.2857 2.30932 17.2857 3.14286V3.92857H18.2129L18.4643 3.93643C19.4231 4.00023 20.3219 4.42615 20.9784 5.1279C21.6349 5.82965 22.0001 6.75474 22 7.71572V18.2144L21.9921 18.4627C21.9287 19.4218 21.503 20.321 20.8012 20.9778C20.0994 21.6347 19.1741 22.0001 18.2129 22H7.71257H7.71572ZM3.14286 15.7143H14.1429C14.5278 15.7142 14.8992 15.5729 15.1869 15.3172C15.4745 15.0614 15.6583 14.709 15.7033 14.3267L15.7143 14.1429V3.14286C15.7142 2.75796 15.5729 2.38647 15.3172 2.09884C15.0614 1.81122 14.709 1.62746 14.3267 1.58243L14.1429 1.57143H3.14286C2.75796 1.57148 2.38647 1.71279 2.09884 1.96855C1.81122 2.22432 1.62746 2.57675 1.58243 2.959L1.57143 3.14286V14.1429C1.57148 14.5278 1.71279 14.8992 1.96855 15.1869C2.22432 15.4745 2.57675 15.6583 2.959 15.7033L3.14286 15.7143ZM8.64286 12.5714C8.45896 12.5715 8.28087 12.507 8.13959 12.3893C7.99832 12.2716 7.90282 12.108 7.86971 11.9271L7.85714 11.7857L7.85872 9.42857H5.5C5.30366 9.42893 5.11429 9.35577 4.9692 9.22349C4.8241 9.09121 4.73379 8.90939 4.71605 8.71385C4.69831 8.51831 4.75443 8.32321 4.87334 8.16698C4.99226 8.01075 5.16537 7.9047 5.35857 7.86971L5.5 7.85714H7.85714V5.5C7.85678 5.30366 7.92995 5.11429 8.06223 4.9692C8.19451 4.8241 8.37632 4.73379 8.57186 4.71605C8.76741 4.69831 8.9625 4.75443 9.11874 4.87334C9.27497 4.99226 9.38102 5.16537 9.416 5.35857L9.42857 5.5V7.85714H11.7857C11.9821 7.85678 12.1714 7.92995 12.3165 8.06223C12.4616 8.19451 12.5519 8.37632 12.5697 8.57186C12.5874 8.76741 12.5313 8.9625 12.4124 9.11874C12.2935 9.27497 12.1203 9.38102 11.9271 9.416L11.7857 9.42857H9.43014L9.42857 11.7857C9.42857 11.8889 9.40825 11.9911 9.36876 12.0864C9.32928 12.1817 9.2714 12.2683 9.19844 12.3413C9.12548 12.4143 9.03887 12.4721 8.94354 12.5116C8.84821 12.5511 8.74604 12.5714 8.64286 12.5714ZM7.71572 20.4286H18.2129L18.4281 20.4191C18.9761 20.3656 19.4845 20.1101 19.8543 19.7022C20.2241 19.2943 20.4288 18.7634 20.4286 18.2129V7.71257L20.4191 7.49886C20.3653 6.95119 20.1095 6.44316 19.7017 6.07368C19.2939 5.7042 18.7632 5.4997 18.2129 5.5H17.2857V14.1429C17.2857 14.9764 16.9546 15.7758 16.3652 16.3652C15.7758 16.9546 14.9764 17.2857 14.1429 17.2857H5.5V18.2129L5.50943 18.4281C5.56292 18.9761 5.8185 19.4845 6.22636 19.8543C6.63423 20.2241 7.16516 20.4288 7.71572 20.4286Z" fill="white"/></svg>
                    </button>
                </div>

                <div id="rtvt-setting-menu">
                    
                    <!--img class="menu-icon-help" width="20" height="20" src=""-->
                    
                    <div id="dl-menu" class="dl-menuwrapper mainmenu">
                    <img class="dl-trigger menu-icon-setting" width="24" height="24" src="" title="${settingsStr}">
                    <ul class="dl-menu">

                        <li>
                            <a role="button" class="rtvt-menu-font menu-user-login">
                                <svg style="background-color: #9B94E2; border-radius: 50%;" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="none" version="1.1" width="38" height="38" viewBox="0 0 38 38"><defs><filter id="master_svg0_3101_19994" filterUnits="objectBoundingBox" color-interpolation-filters="sRGB" x="0" y="0" width="1" height="1"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"/><feColorMatrix in="SourceAlpha" type="matrix" result="hardAlpha" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/><feOffset dy="0" dx="0"/><feGaussianBlur stdDeviation="10"/><feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1"/><feColorMatrix type="matrix" values="0 0 0 0 0.6063132286071777 0 0 0 0 0.5808048844337463 0 0 0 0 0.886904776096344 0 0 0 1 0"/><feBlend mode="normal" in2="shape" result="effect1_innerShadow"/></filter><filter id="master_svg1_3101_19995" filterUnits="objectBoundingBox" color-interpolation-filters="sRGB" x="-0.08677013175608776" y="-0.04761911682000561" width="1.1735402635121754" height="1.1904764672800225"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"/><feOffset dy="1" dx="0"/><feGaussianBlur stdDeviation="0.5"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.10000000149011612 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow" result="shape"/></filter></defs><g><g filter="url(#master_svg0_3101_19994)"></g><g filter="url(#master_svg1_3101_19995)"><g><ellipse cx="18.521611213684082" cy="13.526315689086914" rx="5.547001838684082" ry="5.526315689086914" fill="#FFFFFF" fill-opacity="1"/></g><g><path d="M8.134261530029297,29L29.255599530029297,29C29.845799530029296,29,30.311199530029295,28.4911,30.204299530029296,27.91068C29.155799530029295,22.215429999999998,24.3525995300293,18,18.694999530029296,18C13.037319530029297,18,8.234149530029297,22.215429999999998,7.1856032300292965,27.91068C7.078739730029297,28.4911,7.544069530029297,29,8.134261530029297,29" fill-rule="evenodd" fill="#FFFFFF" fill-opacity="1"/></g></g></g></svg>
                                <span style="display: inline-block; margin-top: -30px; vertical-align: middle; width: 140px;" class="menu-user-login-text">${login_status}</span>
                                <svg style="display: none;" id="logout-btn" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="none" version="1.1" width="13.978515625" height="13.978515625" viewBox="0 0 13.978515625 13.978515625"><g><path d="M13.8496,6.625L11.5215,3.71289C11.4082,3.57227,11.2402,3.49414,11.0664,3.49414C11.002,3.49414,10.9375,3.50391,10.873,3.52734C10.6406,3.60938,10.4844,3.83008,10.4844,4.07617L10.4844,5.82422L5.82422,5.82422C5.18164,5.82422,4.66016,6.3457,4.66016,6.98828C4.66016,7.63086,5.18164,8.15234,5.82422,8.15234L10.4824,8.15234L10.4824,9.90039C10.4824,10.1484,10.6387,10.3672,10.8711,10.4492C10.9336,10.4707,11,10.4824,11.0645,10.4824C11.2383,10.4824,11.4062,10.4043,11.5195,10.2637L13.8496,7.35156C14.0215,7.14062,14.0215,6.83789,13.8496,6.625ZM8.1543,11.6484L3.48438,11.6484C2.8457,11.6484,2.32812,11.127,2.32812,10.4844L2.32812,3.49414L2.32812,3.48438C2.32812,2.8457,2.84961,2.32812,3.49414,2.32812L8.15234,2.32812C8.79492,2.32812,9.31641,1.80664,9.31641,1.16406C9.31641,0.521484,8.79492,0,8.15234,0L2.33008,0C1.04297,0,0,1.04297,0,2.33008L0,11.6484C0,12.9355,1.04297,13.9785,2.33008,13.9785L8.1543,13.9785C8.79688,13.9785,9.31836,13.457,9.31836,12.8145C9.31836,12.1699,8.79688,11.6484,8.1543,11.6484Z" fill="#D4D4D4" fill-opacity="1" style="mix-blend-mode:passthrough"/></g></svg>
                            </a>
                        </li>

                        <li>
                            <div class="menu-inner-div rtvt-menu-subtitle-switch">
                                <span class="menu-inner-title">${subtitlesStr}</span>
                            

                                <label class="switch subtit-switch">
                                    <input type="checkbox" id="subtitle-check" checked>
                                    <span class="slider round"></span>
                                </label>


                            </div>
                        </li>

                        <!--li>
                            <a href="#" class="rtvt-menu-font level1-font">${recoglangStr}<span class="rtvt-lang-show" id="rtvt-asr-lang-show"></span></a>

                            <ul class="dl-submenu" tit="${recoglangStr}" id="rtvt-lang-list-asr">

                            </ul>
                        </li>

                        <li>
                            <a href="#" class="rtvt-menu-font level1-font">${translangStr}<span class="rtvt-lang-show" id="rtvt-alt-lang-show"></span></a>

                            <ul class="dl-submenu" tit="${translangStr}" id="rtvt-lang-list-alt">

                            </ul>
                        </li-->

                        <li>
                        <a href="#" class="rtvt-menu-font menu-font-click">${subtitlesStyleStr}</a>
                        <ul class="dl-submenu" tit="${subtitlesStyleStr}">
                            <li>
                                <div class="rtvt-style-tip" id="rtvt-style-tip">
                                    ${loginToUseStr}
                                </div>
                                
                                <div class="rtvt-color-set">
                                    ${fontColorStr}
                                </div>

                                <div class="rtvt-color-item">
                                    <span class="rtvt-text-color-item rtvt-color-white" value="white"></span>
                                    <span class="rtvt-text-color-item rtvt-color-yellow" value="yellow"></span>
                                    <span class="rtvt-text-color-item rtvt-color-green" value="green"></span>
                                </div>

                                <div class="rtvt-size-set">
                                    ${backgroundOpacityStr}
                                </div>

                                <div class="rtvt-font-item">
                                    <select name="opacity" id="opacity-select">
                                        <option>40%</option>
                                        <option>60%</option>
                                        <option>80%</option>
                                        <option>90%</option>
                                    </select>
                                </div>

                                <div class="rtvt-size-set">
                                    ${fontSizeStr}
                                </div>

                                <div class="rtvt-font-item">
                                    <select name="minbeds" id="minbeds">
                                        <option>1</option>
                                        <option>2</option>
                                        <option>3</option>
                                    </select>

                                    <div class="size-show">
                                        <span class="size-item-span">${smallStr}</span>
                                        <span class="size-item-span">${mediumStr}</span>
                                        <span class="size-item-span">${largeStr}</span>
                                    </div>
                                </div>

                                <div class="rtvt-transparent-set">
                                    ${textStroke}
                                </div>

                                <div class="rtvt-text-shadow">
                                    <label><input type="radio" name="shadow" value="None" checked>${strokeNone}</label>
                                    <label><input type="radio" name="shadow" value="Black">${strokeBlack}</label>
                                    <label><input type="radio" name="shadow" value="White">${strokeWhite}</label>
                                </div>

                                <!--div class="rtvt-transparent-set">
                                    背景透明度:
                                    <span class="rtvt-transparent-item" value="0">50%</span>
                                </div>

                                <div class="slider-container" id="slider">
                                    <div class="slider-progress" id="progress" style="width: 0%;"></div>
                                    <div class="slider-thumb" id="thumb" style="left: 0%;"></div>
                                </div-->

                                <div class="rtvt-size-demo">
                                    ${demotextStr}
                                </div>

                                <div class="menu-inner-div rtvt-menu-highlight-switch">
                                    <span class="menu-inner-title">${highlightCurrentTranslationStr}</span>
                                
                                    <label class="switch highlight-switch">
                                        <input type="checkbox" id="highlight-check" checked>
                                        <span class="slider round"></span>
                                    </label>
                                </div>

                            </li>
                        </ul>
                        </li>

                        <!--li>
                            <a role="button" class="rtvt-menu-font menu-result-download">${downloadSubtitleStr}</a>
                        </li-->

                        <li>
                            <a role="button" class="rtvt-menu-font menu-user-feedback">${userfeedback}</a>
                        </li>

                        <li style="display:none">
                            <a role="button" class="rtvt-menu-font menu-donate">${donateStr}</a>
                        </li>

                        <li>
                            <a href="#" class="rtvt-menu-font">${moreStr}</a>

                            <ul class="dl-submenu" tit="${moreStr}" id="more-sub-menu">
                                <li>
                                    <div class="ball-open-div">
                                        <span class="menu-inner-title">${floatballStr}:</span>
                            
                                        <label class="switch ball-switch">
                                            <input type="checkbox" id="ball-check" checked>
                                            <span class="slider round"></span>
                                        </label>
                                    </div>

                                    <div class="ball-open-desc">
                                        ${floatballdescStr}
                                    </div>
                                </li>
                            </ul>
                        </li>

                         <li>
                            <a role="button" class="rtvt-menu-font menu-jump-help">${tutorialStr}</a>
                        </li>

                    </ul>
                    </div>

                    <div id="close-btn-div">
                    <img class="menu-icon-close" width="26" height="26" src="" title="${closeStr}">
                    </div>

                </div>
            </div>

            <div id="rtvt-content" class="size-l white">
                <div class="no-permission-div">
                    <div class="no-permission-title1">${noPermissionTitle1Str}</div>
                    <div class="no-permission-title2">${noPermissionTitle2Str}</div>
                    <div class="no-permission-block1"></div>
                    <div class="no-permission-block2-outer">
                        <div class="no-permission-block2"></div>
                        <div class="no-permission-block3">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="none" version="1.1" width="11.371337890625" height="10.417724609375" viewBox="0 0 11.371337890625 10.417724609375"><g><g><path d="M-0.00007238699618028477,0C-0.00007238699618028477,0,3.1981976130038197,0,3.1981976130038197,0C3.1981976130038197,0,7.1071976130038195,10.4176,7.1071976130038195,10.4176C7.1071976130038195,10.4176,3.9089276130038195,10.4176,3.9089276130038195,10.4176C3.9089276130038195,10.4176,-0.00007238699618028477,0,-0.00007238699618028477,0Z" fill="#000000" fill-opacity="1"/></g><g><path d="M8.173098766479493,0L11.371368766479492,0L10.562648766479493,2.15527L7.364378766479492,2.15527L8.173098766479493,0ZM6.825208766479492,3.59219L4.264101028479492,10.4176L7.462368766479492,10.4176L10.023478766479492,3.59219L6.825208766479492,3.59219Z" fill-rule="evenodd" fill="#000000" fill-opacity="1"/></g></g></svg>

                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="none" version="1.1" width="10.423809051513672" height="11.364706039428711" viewBox="0 0 10.423809051513672 11.364706039428711"><g><path d="M6.52462,11.3647L1.15393,11.3647C0.8458,11.3647,0.565665,11.2396,0.343831,11.0029C0.11889,10.7629,-2.3315e-7,10.4553,-2.3315e-7,10.1132L-2.3315e-7,8.73345L0.0118257,8.67908C0.0716489,8.40392,0.190747,8.18965,0.365847,8.04218C0.479663,7.94635,0.617742,7.89573,0.765235,7.89573C0.923828,7.89573,1.0877,7.95247,1.26617,8.06922C1.30189,8.09196,1.32362,8.10359,1.33448,8.10897L1.3771,8.11674L1.4356,8.14877C1.56441,8.21929,1.68965,8.25357,1.81846,8.25357C1.95667,8.25357,2.08092,8.22698,2.19835,8.17229C2.31837,8.11637,2.41957,8.04228,2.50769,7.94579C2.59671,7.84832,2.66482,7.73836,2.71596,7.60956C2.765,7.48605,2.78885,7.35311,2.78885,7.20306C2.78885,7.05169,2.76457,6.91567,2.71463,6.7872C2.66354,6.65574,2.59587,6.54495,2.50772,6.44845C2.41956,6.35192,2.31836,6.27781,2.19831,6.2219C2.08096,6.16721,1.95673,6.14063,1.81846,6.14063C1.68941,6.14063,1.56497,6.17036,1.43805,6.23151L1.41959,6.2404L1.40047,6.24737C1.36606,6.25994,1.35116,6.26778,1.34853,6.26922C1.25478,6.32053,1.16155,6.36831,1.07133,6.41125C0.917925,6.48428,0.767409,6.51267,0.626441,6.49551C0.433581,6.47212,0.264042,6.3555,0.149346,6.16719C0.0591086,6.01902,0.0118258,5.82859,0.000496942,5.56782L-1.24958e-7,5.54519L-1.24958e-7,4.29285C-1.24958e-7,3.95314,0.117513,3.64493,0.339813,3.40153C0.562175,3.15812,0.843667,3.0295,1.15393,3.0295L2.13207,3.0295C2.06904,2.81427,2.03715,2.58584,2.03715,2.34874C2.03715,2.02133,2.09528,1.71019,2.20996,1.42396C2.32214,1.14394,2.47546,0.896371,2.66566,0.688123C2.8559,0.479863,3.08202,0.311999,3.33776,0.18919C3.59915,0.0636608,3.87968,3.81033e-7,4.17153,3.81033e-7C4.46336,3.81033e-7,4.74388,0.0636495,5.00531,0.18919C5.26108,0.31201,5.48721,0.479886,5.67741,0.688123C5.86762,0.896371,6.02094,1.14396,6.1331,1.42401C6.24776,1.71016,6.30591,2.02132,6.30591,2.34874C6.30591,2.58819,6.27603,2.81545,6.21661,3.0295L6.52461,3.0295C6.83704,3.0295,7.11804,3.15966,7.33721,3.40592C7.55339,3.64886,7.66763,3.95554,7.66763,4.29285L7.66763,5.06745C7.87468,4.98928,8.09432,4.94972,8.3221,4.94972C8.60545,4.94972,8.87935,5.01083,9.13618,5.13135C9.38964,5.25028,9.61506,5.41668,9.80617,5.62592C9.99729,5.83513,10.1493,6.08195,10.2579,6.35947C10.368,6.64068,10.4238,6.94054,10.4238,7.25072C10.4238,7.56995,10.3676,7.8728,10.2568,8.15085C10.1482,8.42336,9.99655,8.6672,9.80613,8.87562C9.61509,9.08479,9.38968,9.25119,9.1362,9.37016C8.87928,9.49069,8.6054,9.55179,8.32211,9.55179C8.09428,9.55179,7.87466,9.51223,7.66765,9.43406L7.66765,10.1132C7.66765,10.4529,7.55206,10.759,7.33338,10.9985C7.11458,11.2381,6.83493,11.3647,6.52462,11.3647ZM0.869855,8.91795L0.869855,10.1132C0.869855,10.1993,0.893341,10.2595,0.950897,10.3209C1.01101,10.385,1.07173,10.4124,1.15393,10.4124L6.52462,10.4124C6.60558,10.4124,6.66166,10.3871,6.71819,10.3252C6.7747,10.2633,6.79779,10.2019,6.79779,10.1132L6.79779,7.5926L7.5144,8.25953C7.62415,8.36167,7.75187,8.44595,7.89402,8.51007C8.02741,8.57019,8.16744,8.59943,8.32209,8.59943C8.48926,8.59943,8.64346,8.5652,8.79354,8.49481C8.94693,8.4228,9.07698,8.32708,9.19108,8.20216C9.30589,8.07649,9.39368,7.93512,9.45953,7.76994C9.52306,7.61055,9.55395,7.44071,9.55395,7.25071C9.55395,7.06769,9.52268,6.89888,9.45839,6.73462C9.39263,6.56664,9.3052,6.42425,9.1911,6.29935C9.07697,6.17441,8.94693,6.07868,8.7935,6.00669C8.64348,5.93631,8.48927,5.90208,8.32208,5.90208C8.16742,5.90208,8.02737,5.93132,7.89392,5.99147C7.75185,6.05552,7.62412,6.13981,7.51434,6.24198L6.79776,6.90876L6.79776,4.29285C6.79776,4.20285,6.77276,4.13636,6.71417,4.07053C6.65812,4.00755,6.60319,3.98186,6.52459,3.98186L4.54653,3.98186L5.1589,3.1965C5.34539,2.95732,5.43605,2.68002,5.43605,2.34874C5.43605,2.15107,5.40348,1.97371,5.33649,1.80652C5.26697,1.63295,5.17731,1.48741,5.06232,1.36154C4.94733,1.23565,4.8144,1.13744,4.65591,1.06133C4.50319,0.987989,4.34474,0.952356,4.17153,0.952356C3.99831,0.952356,3.83987,0.988001,3.68717,1.06133C3.52869,1.13743,3.39575,1.23562,3.28074,1.36154C3.16577,1.48742,3.07608,1.63295,3.00657,1.80647C2.93957,1.9737,2.90702,2.15108,2.90702,2.34872C2.90702,2.51352,2.93125,2.66202,2.98108,2.8027C3.03374,2.95141,3.10503,3.08781,3.19299,3.20819L3.75833,3.98184L1.15393,3.98184C1.07297,3.98184,1.01529,4.00883,0.954863,4.07497C0.894481,4.14107,0.869845,4.2042,0.869845,4.29285L0.869845,5.46533C0.899513,5.44987,0.929409,5.43389,0.959409,5.41746C1.0023,5.39397,1.05045,5.37216,1.10607,5.35108C1.3367,5.24305,1.57625,5.18829,1.81844,5.18829C2.07252,5.18829,2.31493,5.24122,2.53893,5.34562C2.76025,5.44873,2.9567,5.59321,3.12277,5.77504C3.28884,5.95685,3.42081,6.17193,3.51501,6.41431C3.61033,6.65955,3.65868,6.92494,3.65868,7.20307C3.65868,7.48246,3.60989,7.74698,3.51366,7.98929C3.41954,8.22632,3.28802,8.43826,3.12277,8.61919C2.95674,8.80099,2.76028,8.94549,2.53887,9.04863C2.31477,9.15302,2.07239,9.20593,1.81844,9.20593C1.57119,9.20593,1.3271,9.145,1.09212,9.02472C1.02552,9.00318,0.953631,8.96859,0.869855,8.91795Z" fill="#3D3D3D" fill-opacity="1" style="mix-blend-mode:passthrough"/></g></svg>
                        </div>
                    </div>

                    <div class="no-permission-bottom-outer">
                        <div class="no-p-left-logo">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="none" version="1.1" width="11.371337890625" height="10.417724609375" viewBox="0 0 11.371337890625 10.417724609375"><g><g><path d="M-0.00007238699618028477,0C-0.00007238699618028477,0,3.1981976130038197,0,3.1981976130038197,0C3.1981976130038197,0,7.1071976130038195,10.4176,7.1071976130038195,10.4176C7.1071976130038195,10.4176,3.9089276130038195,10.4176,3.9089276130038195,10.4176C3.9089276130038195,10.4176,-0.00007238699618028477,0,-0.00007238699618028477,0Z" fill="#000000" fill-opacity="1"/></g><g><path d="M8.173098766479493,0L11.371368766479492,0L10.562648766479493,2.15527L7.364378766479492,2.15527L8.173098766479493,0ZM6.825208766479492,3.59219L4.264101028479492,10.4176L7.462368766479492,10.4176L10.023478766479492,3.59219L6.825208766479492,3.59219Z" fill-rule="evenodd" fill="#000000" fill-opacity="1"/></g></g></svg>
                        </div>

                        <span class="no-p-logo-text">ViiTor</span>

                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="none" version="1.1" width="11.371428489685059" height="11.364706039428711" viewBox="0 0 11.371428489685059 11.364706039428711"><defs><clipPath id="master_svg0_1347_37161"><rect x="0" y="0" width="11.371428489685059" height="11.364706039428711" rx="0"/></clipPath></defs><g clip-path="url(#master_svg0_1347_37161)"><g><path d="M6.193500078125,7.63565484375L6.193500078125,10.83621484375L5.177530078125001,10.83621484375L5.177530078125001,7.63565484375L2.526568078125,7.63565484375C2.419961078125,7.63565484375,2.326147078125,7.59445484375,2.249389078125,7.51064484375C2.172707478125,7.43097484375,2.130568268125,7.32428484375,2.132121592725,7.21374484375C2.132121592725,6.67249484375,2.292388078125,6.18488484375,2.616118078125,5.75053484375C2.939493078125,5.31796484375,3.303730078125,5.10061484375,3.7106200781250003,5.10061484375L3.7106200781250003,2.2253448437500003C3.496340078125,2.2253448437500003,3.3126200781249997,2.1415348437499997,3.154840078125,1.97390484375C3.001739078125,1.81395484375,2.917529078125,1.60036484375,2.920303078125,1.3790298437500002C2.920303078125,1.1496048437500002,2.998482078125,0.95285384375,3.154840078125,0.78415884375C3.310130078125,0.61795014375,3.495980078125,0.53271484375,3.7106200781250003,0.53271484375L7.659350078125,0.53271484375C7.873630078125,0.53271484375,8.057350078125001,0.61652954375,8.215120078125,0.78415884375C8.370420078125,0.95178884375,8.450020078125,1.1496048437500002,8.450020078125,1.3790298437500002C8.450020078125,1.60845484375,8.371840078125,1.80520484375,8.215480078125001,1.97390484375C8.058770078125,2.14295484375,7.873630078125,2.2253448437500003,7.659350078125,2.2253448437500003L7.659350078125,5.09919484375C8.066230078124999,5.09919484375,8.431890078125,5.31654484375,8.753850078125,5.74911484375C9.073160078125,6.17029484375,9.243860078125,6.68533484375,9.239260078125,7.21374484375C9.239260078125,7.32774484375,9.200890078125,7.42825484375,9.122350078124999,7.51064484375C9.044170078125,7.59303484375,8.951780078125001,7.63565484375,8.845170078125001,7.63565484375L6.193850078125,7.63565484375L6.193500078125,7.63565484375Z" fill="#376BE3" fill-opacity="1" style="mix-blend-mode:passthrough"/></g></g></svg>

                        <svg class="no-p-last-svg" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="none" version="1.1" width="10.423809051513672" height="10.417646408081055" viewBox="0 0 10.423809051513672 10.417646408081055"><defs><clipPath id="master_svg0_1347_37165"><rect x="0" y="0" width="10.423809051513672" height="10.417646408081055" rx="0"/></clipPath></defs><g clip-path="url(#master_svg0_1347_37165)"><g><path d="M5.212156859375,8.247566171875C5.691895859375,8.247566171875,6.080805859375,8.636236171875,6.080805859375,9.115696171875C6.080805859375,9.595156171875,5.691895859375,9.983836171875,5.212156859375,9.983836171875C4.732413859375,9.983836171875,4.343506170029,9.595156171875,4.343505859375,9.115696171875C4.343506170029,8.636236171875,4.732413859375,8.247566171875,5.212156859375,8.247566171875ZM4.343505859375,5.209086171875C4.343506170029,5.688536171875,4.732413859375,6.077216171875,5.212156859375,6.077216171875C5.691895859375,6.077216171875,6.080805859375,5.688536171875,6.080805859375,5.209086171875C6.080805859375,4.729626171875,5.691895859375,4.340946171875,5.212156859375,4.340946171875C4.732413859375,4.340946171875,4.343506170029,4.729626171875,4.343505859375,5.209086171875ZM4.343505859375,1.302463171875C4.343506170029,1.781926171875,4.732413859375,2.170596171875,5.212156859375,2.170596171875C5.691895859375,2.170596171875,6.080805859375,1.781926171875,6.080805859375,1.302463171875C6.080805859375,0.8230041718750001,5.691895859375,0.434326171875,5.212156859375,0.434326171875C4.732413859375,0.4343260942575,4.343506170029,0.8230041718750001,4.343505859375,1.302463171875Z" fill="#5C5C66" fill-opacity="1" style="mix-blend-mode:passthrough"/></g></g></svg>

                        <div class="no-permission-pointer">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="none" version="1.1" width="23.690475463867188" height="27.464704513549805" viewBox="0 0 23.690475463867188 27.464704513549805"><g><path d="M21.0744,10.5468L21.0027,10.5468C20.4723,10.5468,20.037,10.6947,19.6177,10.9464C19.2508,9.90809,18.3176,9.16013,17.1156,9.16013C16.5852,9.16013,16.0786,9.30795,15.6594,9.55972C15.2924,8.52142,14.3588,7.77342,13.1567,7.77342C12.6879,7.77342,12.2523,7.88739,11.8666,8.08763L11.8666,5.41603C11.8666,3.96087,10.7324,2.78126,9.22184,2.78126C7.71129,2.78126,6.48679,3.96087,6.48679,5.41603L6.48679,15.6447L4.82519,14.039C3.75707,13.0101,1.86664,13.1566,0.95722,14.039C0.0478005,14.9215,-0.548612,16.6976,0.753658,17.9613L8.39185,25.3243C8.54943,25.4761,8.72266,25.6027,8.90488,25.7097C10.2975,26.8121,11.8933,27.4647,15.2678,27.4647C22.9766,27.4647,23.6905,23.4292,23.6905,18.4511L23.6905,13.1815C23.6904,11.7264,22.585,10.5468,21.0744,10.5468ZM22.2509,18.451C22.2509,22.6632,22.2301,26.0779,15.2677,26.0779C12.3183,26.0779,10.5475,25.4398,9.2061,24.1476L1.9751,17.1768C1.33534,16.556,1.49622,15.7623,2.01996,15.254C2.54367,14.7459,3.50491,14.7283,4.01087,15.2157Q5.27952,16.4394,6.37252,17.4937Q7.19969,18.2916,7.92629,18.9925L7.92629,5.69337C7.92629,5.00411,8.50633,4.44535,9.22184,4.44535C9.93732,4.44535,10.4271,5.00414,10.4271,5.69337L10.4271,14.1523L10.4416,14.1523C10.4322,14.1971,10.4271,14.2434,10.4271,14.291C10.4271,14.6739,10.7494,14.9843,11.1469,14.9843C11.5443,14.9843,11.8666,14.6739,11.8666,14.291C11.8666,14.2434,11.8615,14.1971,11.8521,14.1523L11.8666,14.1523L11.8666,10.6855C11.8666,9.99623,12.3842,9.43744,13.0998,9.43744Q14.3675,9.4208,14.3675,10.6855L14.3675,15.2616L14.382,15.2616C14.3725,15.3064,14.3675,15.3528,14.3675,15.4003C14.3675,15.7832,14.6897,16.0936,15.0872,16.0936C15.4847,16.0936,15.8069,15.7832,15.8069,15.4003C15.8069,15.3528,15.8019,15.3064,15.7924,15.2616L15.8069,15.2616L15.8069,12.0722C15.8069,11.3829,16.3163,10.8241,17.0319,10.8241Q18.3258,10.9023,18.3258,12.0722L18.3258,16.0936L18.3404,16.0936C18.3309,16.1384,18.3258,16.1848,18.3258,16.2323C18.3258,16.6152,18.6481,16.9257,19.0456,16.9257C19.4431,16.9257,19.7473,16.6153,19.7473,16.2323C19.7473,16.1848,19.7425,16.1384,19.7336,16.0936L19.7473,16.0936L19.7473,13.348C19.7473,12.6587,20.281,12.0999,20.9965,12.0999Q22.2509,12.0507,22.2509,13.348Q22.2509,17.3295,22.2509,18.451ZM5.41807,9.34438L5.41807,7.01432C5.18956,6.51725,5.05979,5.96806,5.05979,5.38863C5.05979,3.18059,6.90449,1.39061,9.18003,1.39061C11.4556,1.39061,13.3003,3.18059,13.3003,5.38863C13.3003,5.69025,13.2635,5.98307,13.1976,6.26523C13.7158,6.28486,14.1834,6.49358,14.5238,6.82871C14.6557,6.36977,14.7334,5.88879,14.7334,5.38863C14.7334,2.41259,12.247,0,9.18,0C6.11298,0,3.62663,2.41259,3.62663,5.38863C3.62666,6.95443,4.31912,8.35981,5.41807,9.34438Z" fill="#A08AF9" fill-opacity="1" style="mix-blend-mode:passthrough"/></g></svg>
                        </div>
                    </div>
                </div>

                <div class="help-card card-hidden">
                    <div class="help-card-title">
                        ${guide1}
                    </div>
                    <div class="help-card-content">
                        <p class="card-p1">${guide2}</p>
                        <p class="card-step-tit">${guide3}</p>
                        <p class="card-step-text">${guide4}</p>
                        <p class="card-step-tit">${guide5}</p>
                        <p class="card-step-text">${guide6}</p>
                        <p class="card-step-tit">${guide7}</p>
                        <p class="card-step-text">${guide8}</p>
                    </div>

                    <div class="help-card-btn">
                        <span id="card-ok-btn">${guide9}</span>
                    </div>
                </div>

                <div class="login-required-card card-hidden">
                    <div class="login-required-content">
                        <span class="login-required-desc">${loginRequiredDescStr}</span>
                        <button id="login-now-btn" class="login-now-btn">${loginNowStr}</button>
                    </div>
                </div>

                <div id="rating-modal" class="rating-modal card-hidden">
                    <div class="rating-modal-content">
                        <button id="rating-close-btn" class="rating-close-btn">×</button>
                        
                        <!-- 页面1: 点赞点踩页面 -->
                        <div id="rating-page" class="rating-page">
                            <div class="rating-modal-title">
                                ${ratingTitleStr}
                            </div>
                            <div id="pausing-icon" class="pausing-icon card-hidden">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#3D3D3D" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <rect x="6" y="4" width="4" height="16"></rect>
                                    <rect x="14" y="4" width="4" height="16"></rect>
                                </svg>
                            </div>
                            <div class="rating-buttons">
                                <button id="rating-dislike" class="rating-btn">
                                    <svg class="rating-icon-dislike" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="none" version="1.1" width="27.818241119384766" height="23.875" viewBox="0 0 27.818241119384766 23.875"><g transform="matrix(-1,0,0,1,53.63648223876953,0)"><path d="M30.618241319384765,14.583282L30.618241319384765,2L28.418241219384765,2Q27.818241119384766,2,27.818241119384766,2.5625L27.818241119384766,14.020828Q27.818241119384766,14.583282,28.418241219384765,14.583282L30.618241319384765,14.583282ZM35.16004941938476,17.131907Q34.50058651938477,15.086417,32.618241819384764,14.682608L32.618241819384764,2L46.29904411938477,1.9999998799999998Q47.84025011938476,1.9999998799999998,48.36675311938477,3.3995337L51.501461119384764,11.732837Q51.889004119384765,12.763166,51.24409711938476,13.665419Q50.58803011938477,14.583282,49.43360311938477,14.583282L40.21824211938477,14.583282L40.21824211938477,19.913441Q40.21824211938477,21.875,38.18561811938476,21.875Q36.68934341938477,21.875,36.24476051938477,20.496098L35.16004941938476,17.131907ZM28.418241219384765,16.583282L31.618241319384765,16.583282Q32.88180161938477,16.583282,33.256530319384765,17.745598L34.341258519384766,21.10984Q35.23279471938476,23.875,38.18561811938476,23.875Q39.84905111938477,23.875,41.028678119384764,22.723019Q42.21824211938477,21.561331,42.21824211938477,19.913441L42.21824211938477,16.583282L49.43360311938477,16.583282Q51.616856119384764,16.583282,52.871187119384764,14.828423Q54.136682119384766,13.057947,53.373421119384766,11.028727L50.238689119384766,2.6953728Q49.22469511938476,-1.9999999989472883e-7,46.29904411938477,-1.9999999989472883e-7L31.618241319384765,0L28.418241219384765,0Q25.818241119384766,0,25.818241119384766,2.5625L25.818241119384766,14.020828Q25.818241119384766,16.583282,28.418241219384765,16.583282Z" fill-rule="evenodd" fill="#3D3D3D" fill-opacity="1" style="mix-blend-mode:passthrough"/></g></svg>
                                </button>
                                <button id="rating-like" class="rating-btn">
                                    <svg class="rating-icon-like" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="none" version="1.1" width="27.818241119384766" height="23.875" viewBox="0 0 27.818241119384766 23.875"><g transform="matrix(1,0,0,-1,0,45.75)"><path d="M4.8000001999999995,36.458282L4.8000001999999995,23.875L2.6000001,23.875Q2,23.875,2,24.4375L2,35.895828Q2,36.458282,2.6000001,36.458282L4.8000001999999995,36.458282ZM9.3418083,39.006907Q8.682345399999999,36.961417,6.8000007,36.557608L6.8000007,23.875L20.480803,23.87499988Q22.022009,23.87499988,22.548512,25.2745337L25.68322,33.607837Q26.070763,34.638166,25.425856,35.540419Q24.769789,36.458282,23.615362,36.458282L14.400001,36.458282L14.400001,41.788441Q14.400001,43.75,12.367377,43.75Q10.8711023,43.75,10.4265194,42.371098L9.3418083,39.006907ZM2.6000001,38.458282L5.8000002,38.458282Q7.0635605,38.458282,7.4382892,39.620598L8.5230174,42.98484Q9.4145536,45.75,12.367377,45.75Q14.03081,45.75,15.210437,44.598019Q16.400001,43.436330999999996,16.400001,41.788441L16.400001,38.458282L23.615362,38.458282Q25.798615,38.458282,27.052946,36.703423Q28.318441,34.932947,27.55518,32.903727L24.420448,24.5703728Q23.406454,21.8749998,20.480803,21.8749998L5.8000002,21.875L2.6000001,21.875Q0,21.875,0,24.4375L0,35.895828Q0,38.458282,2.6000001,38.458282Z" fill-rule="evenodd" fill="#3D3D3D" fill-opacity="1" style="mix-blend-mode:passthrough"/></g></svg>
                                </button>
                            </div>
                        </div>
                        
                        <!-- 页面2: 反馈页面 -->
                        <div id="feedback-page" class="feedback-page card-hidden">
                            <select id="feedback-select" class="feedback-select">
                                <option value="">${feedbackSelectPlaceholderStr}</option>
                                <option value="subtitle_missing">${feedbackOptionSubtitleMissingStr}</option>
                                <option value="translation_no_result">${feedbackOptionTranslationNoResultStr}</option>
                                <option value="recognition_inaccuracy">${feedbackOptionRecognitionInaccuracyStr}</option>
                                <option value="translation_inaccuracy">${feedbackOptionTranslationInaccuracyStr}</option>
                                <option value="network_error">${feedbackOptionNetworkErrorStr}</option>
                                <option value="subtitle_fast">${feedbackOptionSubtitleFastStr}</option>
                                <option value="language_missing">${feedbackOptionLanguageMissingStr}</option>
                                <option value="other">${feedbackOptionOtherStr}</option>
                            </select>
                            <input type="text" id="feedback-other-input" class="feedback-other-input card-hidden" placeholder="${feedbackOtherPlaceholderStr}" maxlength="100">
                            <div class="feedback-buttons">
                                <button id="feedback-submit" class="feedback-submit-btn">${feedbackSubmitBtnStr}</button>
                                <button id="feedback-cancel" class="feedback-cancel-btn">${feedbackReturnBtnStr}</button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="scrollDownButton">
                    <?xml version="1.0" standalone="no"?><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd"><svg t="1733364784664" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="1620" xmlns:xlink="http://www.w3.org/1999/xlink" width="200" height="200"><path d="M468.7 584.1c24.5 24 64.3 24 88.8 0l448-436.4c24.5-24 24.5-62.8 0-86.7-24.5-24-64.3-24-88.8 0L513.1 454.1 109.5 61C85 37 45.2 37 20.7 61s-24.5 62.8 0 86.7l448 436.4z m448.1-144.7L513.1 832.5 109.5 439.4c-24.5-24-64.3-24-88.8 0s-24.5 62.8 0 86.7l448 436.4c24.5 24 64.3 24 88.8 0l448-436.4c24.5-24 24.5-62.8 0-86.7-24.4-24-64.2-24-88.7 0z" fill="#ffffff" p-id="1621"></path></svg>
                </div>
            </div>
        
        </div>
    */});

        if ($('#rtvt-main-container').length == 0) {
        $("body").append(containerHtml({stopTransStr, settingsStr, subtitlesStr, recoglangStr, translangStr, subtitlesStyleStr, fontColorStr, fontSizeStr, smallStr, mediumStr, largeStr, closeStr, guide1, guide2, guide3, guide4, guide5, guide6, guide7, guide8, guide9, moreStr, floatballStr, floatballdescStr, demotextStr, noPermissionTitle1Str, noPermissionTitle2Str, tutorialStr, userfeedback, textStroke, strokeNone, strokeBlack, strokeWhite, backgroundOpacityStr, login_status, highlightCurrentTranslationStr, loginTextStr, downloadSubtitleStr, ratingTitleStr, feedbackSelectPlaceholderStr, feedbackOptionSubtitleMissingStr, feedbackOptionTranslationNoResultStr, feedbackOptionRecognitionInaccuracyStr, feedbackOptionTranslationInaccuracyStr, feedbackOptionNetworkErrorStr, feedbackOptionSubtitleFastStr, feedbackOptionLanguageMissingStr, feedbackOptionOtherStr, feedbackOtherPlaceholderStr, feedbackSubmitBtnStr, feedbackReturnBtnStr, feedbackSuccessMessageStr, loginRequiredDescStr, loginNowStr, donateStr, donateIconUrlUnpaid, donateBtnTitleStr }));

        $('body').find('#rtvt-top-logo').append('<img id="rtvt-logo-img" width="64" height="22" src="' + logoBase64 + '">');

        $('body').find('.menu-icon-setting').attr('src', settingBase64);

        $('#dl-menu').dlmenu({
            animationClasses : { classin : 'dl-animate-in-4', classout : 'dl-animate-out-4' }
        });

        $('body').find('.menu-icon-close').attr('src', closeBase64);
        $('body').find('.menu-icon-help').attr('src', helpBase64);

        $('body').find("#rtvt-main-container" ).resizable({
            minWidth: mainMinWidth,
            minHeight: mainMinHeight,
            handles: "n, e, s, w, ne, se, sw, nw",
            containment: "document" // window无故报错, 先采用document的方式
        }, {
            stop: function(event, ui) {
                saveContainerPosition();
                if (hideMenuFlag) {
                    isMoveing = false;

                    // 移动会屏蔽鼠标leave事件，故再次判断隐藏菜单
                    if(!$('#rtvt-main-container').is(':hover')) {
                        $('#rtvt-top-menu').addClass('rtvt-top-menu-hidden');
                        $('#rtvt-content').css('border-radius', '10px');
                    }
                }
            },
            resize: function(event, ui) {
                // 限制在窗口高度范围内
                const windowHeight = $(window).height();
                const maxHeight = windowHeight - ui.position.top;
                if (ui.size.height > maxHeight) {
                    ui.size.height = maxHeight;
                }
            },
            start : function(event, ui) {
                if (hideMenuFlag) {
                    isMoveing = true;
                }
            }
        });

        $("#rtvt-main-container").draggable({
            handle: "#rtvt-top-menu",
            containment: "window"
        }, {
            stop: function(event, ui) {
                saveContainerPosition();
            }
        });

        $('.menu-icon-close').on('click', function() {
            closeClick();
        });

        $('.menu-jump-help').on('click', function() {
            //helpCardShow();
            
            const clickEvent = new MouseEvent('click', {
                bubbles: true,
                cancelable: true,
                view: window
            });
            document.getElementById('rtvt-content').dispatchEvent(clickEvent);

            chrome.runtime.sendMessage({ action: 'jump_help' });
        });

        // 复制字幕功能
        function copySubtitle() {
            if (isLogin) {
                let result = "";
                $(".rtvt-result-div").each(function() {
                    let asr = $(this).find(".rtvt-asr-result").text().trim();
                    let alt = $(this).find(".rtvt-alt-result").text().trim();
                    result += asr + "\n" + alt + "\n\n";
                });
                //chrome.runtime.sendMessage({ action: 'donwload_result', text : result });
                navigator.clipboard.writeText(result).then(function() {
                    var copySuccessStr = chrome.i18n.getMessage("copy_success");
                    showToast(copySuccessStr || '复制成功', 1000, '#rtvt-content');
                }, function(err) {
                    console.error('Could not copy text: ', err);
                    var copyFailedStr = chrome.i18n.getMessage("copy_failed");
                    showToast(copyFailedStr || '复制失败', 1000, '#rtvt-content');
                });
            } else {
                sendLoginQuest();
            }
        }

        // 复制字幕按钮（菜单中）
        $('.menu-result-download').on('click', function() {
            copySubtitle();
        });

        // 复制按钮（顶部）
        $('.rtvt-top-copy-link').on('click', function() {
            copySubtitle();
        });

        // 打开捐赠页面功能
        function openDonatePage() {
            if (!isLogin) {
                sendLoginQuest();
                return;
            }

            uploadDonateLog(globalConfig.uid);

            let base64Uid = btoa(globalConfig.uid);
            chrome.runtime.sendMessage({ action: 'user_donate', uid: base64Uid });

            // setTimeout(() => {
            //     const donateThanksStr = chrome.i18n.getMessage("donate_thanks_toast");
            //     showToast(donateThanksStr || "感谢您的支持!", 30000, '#rtvt-content', true, false);
            // }, 500);
        }

        // 捐赠按钮（顶部）- 点击切换图片
        $('.rtvt-top-donate-link').on('click', function() {
            openDonatePage();
            if (false) {
                const currentSrc = $('.rtvt-top-donate-img').attr('src');
                if (currentSrc === DONATE_ICON_UNPAID_URL) {
                    setDonateIconVip();
                } else {
                    setDonateIconUnpaid();
                }
            }
        });

        $('.menu-user-feedback').on('click', function() {
            //helpCardShow();
            
            const clickEvent = new MouseEvent('click', {
                bubbles: true,
                cancelable: true,
                view: window
            });
            document.getElementById('rtvt-content').dispatchEvent(clickEvent);

            chrome.runtime.sendMessage({ action: 'user_feedback' });
        });

        $('.menu-donate').on('click', function() {
            openDonatePage();
        });

        $('.menu-font-click').on('click', function() {
            setTimeout(() => {
                if (globalConfig.textShadow == undefined) {
                    globalConfig.textShadow = 'None';
                }
                document.querySelector('input[name="shadow"][value="' + globalConfig.textShadow + '"]').click();
            }, 0);
        });

        $('.menu-user-login').on('click', function() {
            // 点击后菜单消失
            // console.log("menu-user-login click");
            // const clickEvent = new MouseEvent('click', {
            //     bubbles: true,
            //     cancelable: true,
            //     view: window
            // });
            // document.getElementById('rtvt-content').dispatchEvent(clickEvent);

            if (isLogin) {
                return;
                
            }else {
                sendLoginQuest();
            }
        });

        // 顶部登录按钮点击事件
        $('.rtvt-top-login-link').on('click', function() {
            if (isLogin) {
                return;
            } else {
                sendLoginQuest();
            }
        });
        
        // 确保事件绑定后tooltip仍然存在
        updateLoginTooltip();

        // 单独为 logout-btn 添加点击事件
        $('#logout-btn').on('click', function(e) {
            e.stopPropagation();
            var login_status = chrome.i18n.getMessage("login_status");
            $('.menu-user-login-text').text(login_status);
            // $('.rtvt-top-login-text').text(login_status);
            let old_uid = globalConfig.uid;
            globalConfig.uid = generateUUID();
            logOut();
            uploadLog("userLogout", "user click logout button, old uid: " + old_uid);
            isLogin = false;
            $('#logout-btn').hide();
            setDonateIconUnpaid();
            // 显示登录提示
            loginRequiredCardShow();
            pauseRecording(tabId);
            // $('#rtvt-top-login-btn').show();
            updateSubtitleStyleAccess();
            updateLoginTooltip();
        });

        $('#card-ok-btn').on('click', function() {
            helpCardShow();
        });

        $('#login-now-btn').on('click', function() {
            sendLoginQuest();
        });

        // 点赞点踩按钮事件监听器
        $('#rating-like').on('click', function() {
            handleRatingClick(true);
        });

        $('#rating-dislike').on('click', function() {
            handleRatingClick(false);
        });

        // 关闭按钮事件监听器
        $('#rating-close-btn').on('click', function() {
            hideRatingModal();
        });

        // 反馈表单事件监听器
        $('#feedback-submit').on('click', function() {
            var selectedFeedback = $('#feedback-select').val();
            if (!selectedFeedback) {
                return; // 如果没有选择，直接返回（按钮应该是禁用状态）
            }

            // 提交反馈后，点踩才算真正完成
            hasRated = true;

            // 这里可以添加发送反馈到服务器的逻辑
            let content;
            if (selectedFeedback === 'other') {
                content = $('#feedback-other-input').val().trim();
            } else {
                content = $('#feedback-select option:selected').text();
            }
            
            let data = {
                pid: PID.toString(), 
                streamId: g_streamID,
                userId: globalConfig.uid.toString(), 
                command: 1,
                ts: Math.floor(Date.now() / 1000).toString(), 
                srcLang: globalConfig.asrLang["key"],
                targetLang: globalConfig.altLang["key"],
                type : selectedFeedback,
                content : content, // 下拉列表中的内容或用户输入的内容
                platform: "extension_" + getBrowserInfo(),
                function: "extensionTranslate"
            }
            
            feedback_function(data);
            uploadLog("feedback", "feedback submit, type: " + data.command + ", content: " + data.content);
            
            // 显示提交成功信息
            $('#feedback-select').hide();
            $('.feedback-buttons').hide();
            // 隐藏右上角关闭按钮
            $('#rating-close-btn').hide();
            
            // 在反馈页面添加成功提示
            $('#feedback-page').append('<div class="feedback-success-msg">' + chrome.i18n.getMessage("feedback_success_message") + '</div>');
            
            // 2秒后关闭模态框
            setTimeout(function() {
                hideRatingModal();
                // 重置反馈页面状态
                $('#feedback-select').show().val('');
                $('#feedback-other-input').addClass('card-hidden').val('');
                $('.feedback-buttons').show();
                $('.feedback-success-msg').remove();
                // 重新显示关闭按钮
                $('#rating-close-btn').show();
                // 重置提交按钮为禁用状态
                $('#feedback-submit').prop('disabled', true);
            }, 1000);
        });

        $('#feedback-cancel').on('click', function() {
            showRatingPage();
        });

        // 监听下拉框变化，控制提交按钮状态和输入框显示
        $('#feedback-select').on('change', function() {
            var selectedValue = $(this).val();
            
            // 控制输入框显示
            if (selectedValue === 'other') {
                $('#feedback-other-input').removeClass('card-hidden');
                // 当选择"其他"时，需要检查输入框是否有内容
                checkOtherInputAndUpdateButton();
            } else {
                $('#feedback-other-input').addClass('card-hidden').val('');
                // 非"其他"选项时，只要有选择就启用按钮
                if (selectedValue) {
                    $('#feedback-submit').prop('disabled', false);
                } else {
                    $('#feedback-submit').prop('disabled', true);
                }
            }
        });

        // 监听"其他"输入框的变化
        $('#feedback-other-input').on('input', function() {
            checkOtherInputAndUpdateButton();
        });

        // 检查"其他"输入框并更新按钮状态的函数
        function checkOtherInputAndUpdateButton() {
            var selectedValue = $('#feedback-select').val();
            var otherInputValue = $('#feedback-other-input').val().trim();
            
            if (selectedValue === 'other') {
                if (otherInputValue) {
                    $('#feedback-submit').prop('disabled', false);
                } else {
                    $('#feedback-submit').prop('disabled', true);
                }
            }
        }

        $('.dl-submenu').each(function() {
            let text = $(this).attr('tit');
            $(this).find('.dl-back').find('a').text(text);
        });

        $('.rtvt-text-color-item').on('click', function() {
			//$('body').trigger('click');

            if (!isLogin) {
                updateSubtitleStyleAccess();
                return;
            }

            globalConfig.textColor = $(this).attr('value');
            $('#rtvt-content').removeClass('white');
            $('#rtvt-content').removeClass('yellow');
            $('#rtvt-content').removeClass('green');
            $('#rtvt-content').addClass(globalConfig.textColor);

            globalConfig.textColor = $(this).attr('value');
            $('.rtvt-size-demo').removeClass('white');
            $('.rtvt-size-demo').removeClass('yellow');
            $('.rtvt-size-demo').removeClass('green');
            $('.rtvt-size-demo').addClass(globalConfig.textColor);

            $('.rtvt-text-color-item').removeClass('sel-color');
            $(this).addClass('sel-color');

            chrome.storage.local.set({ textColor : globalConfig.textColor }).then(() => {
                //console.log("change and save text color");
            });
        });

        updateSubtitleStyleAccess();

        $('#rtvt-style-tip').on('click', function(event) {
            event.stopPropagation();
            if (isLogin) {
                return;
            }
            sendLoginQuest();
        });

        $('.rtvt-text-size-item').on('click', function() {
            $('body').trigger('click');

            if (!isLogin) {
                updateSubtitleStyleAccess();
                return;
            }

            globalConfig.textSize = $(this).attr('value');
            $('#rtvt-content').removeClass('size-s');
            $('#rtvt-content').removeClass('size-l');
            $('#rtvt-content').removeClass('size-xl');
            $('#rtvt-content').addClass(globalConfig.textSize);

            $('.rtvt-size-demo').removeClass('size-s');
            $('.rtvt-size-demo').removeClass('size-l');
            $('.rtvt-size-demo').removeClass('size-xl');
            $('.rtvt-size-demo').addClass(globalConfig.textSize);

            $('.rtvt-text-size-item').removeClass('sel-size');
            $(this).addClass('sel-size');

            chrome.storage.local.set({ textSize : globalConfig.textSize }).then(() => {
                //console.log("change and save text size");
            });
        });

        $('.rtvt-opacity-item').on('click', function() {
            //const val = $(this).attr('data-opacity');
            //console.log('[RTVT] 透明度选项点击: ' + val + '%');
        });

        $('#rtvt-pause-btn').on('click', function() {
            // 未登录时，点击暂停按钮跳转到登录页面
            if (!isLogin) {
                sendLoginQuest();
                return;
            }

            if ($(this).attr('val') == 'play') {
                $(this).attr('val', 'pause');
                $(this).text(chrome.i18n.getMessage("starttrans"));
                pauseRecording(tabId, false);
                // 显示点赞点踩页面
                showRatingModal();
            } else {
                $(this).attr('val', 'play');
                $(this).text(chrome.i18n.getMessage("stoptrans"));
                resumeRecording(tabId, false);
                // 关闭点赞点踩页面
                hideRatingModal();
            }
            // start 
            // 之前是点赞点踩完才为true，现在改为仅暂停第一次时显示点赞点踩
            hasRated = true;
            // end
        });

        $('.scrollDownButton').on('click', function() {
            $('#rtvt-content').scrollTop($('#rtvt-content')[0].scrollHeight);
        });

        $('#rtvt-content').scroll(function() {
            if ($('#rtvt-content').scrollTop() + $('#rtvt-content').height() + 40 + scrollFactor < $('#rtvt-content').prop('scrollHeight')) {
                $('.scrollDownButton').show();
            } else {
                $('.scrollDownButton').hide();
            }
        });

        $("#subtitle-check").change(function() {
            if ($(this).is(":checked")) {
                globalConfig.openSubtitle = 1;
            } else {
                globalConfig.openSubtitle = 0;
            }

            chrome.storage.local.set({ openSubtitle : globalConfig.openSubtitle }).then(() => {
                //reloadRTVTClient();
            });
        });

        $('#ball-check').change(function() {
            if ($(this).is(":checked")) {
                globalConfig.openBall = 1;

                $('#rtvt-autoinsert-div').show();
            } else {
                globalConfig.openBall = 0;

                $('#rtvt-autoinsert-div').hide();
            }

            chrome.storage.local.set({ openBall : globalConfig.openBall }).then(() => {

            });
        });

        $("#highlight-check").change(function(event) {
            if (!isLogin && event && event.originalEvent) {
                $(this).prop('checked', !!(globalConfig.highlightCurrentTranslation == 1 || globalConfig.highlightCurrentTranslation == '1'));
                updateSubtitleStyleAccess();
                return;
            }
            console.log("highlight-check change: ", $(this).is(":checked"));
            if ($(this).is(":checked")) {
                globalConfig.highlightCurrentTranslation = 1;
                $('.rtvt-tmp-result .rtvt-alt-result').addClass('size-xxl');
                $('.rtvt-tmp-result .rtvt-asr-result').addClass('size-xxl');
            } else {
                globalConfig.highlightCurrentTranslation = 0;
                // 关闭开关时移除所有高亮样式
                $('.rtvt-tmp-result .rtvt-alt-result').removeClass('size-xxl');
                $('.rtvt-tmp-result .rtvt-asr-result').removeClass('size-xxl');
            }

            chrome.storage.local.set({ highlightCurrentTranslation : globalConfig.highlightCurrentTranslation }).then(() => {
                //reloadRTVTClient();
            });
        });

        if (hideMenuFlag) {
            $('#rtvt-main-container').on('mouseenter', function() {
                //console.log("mouseenter");
                $('#rtvt-top-menu').removeClass('rtvt-top-menu-hidden');
                $('#rtvt-content').css('border-radius', '0 0 10px 10px');
            });

            // 监听鼠标离开容器
            $('#rtvt-main-container').on('mouseleave', function() {
                if (!isMoveing) {
                    $('#rtvt-top-menu').addClass('rtvt-top-menu-hidden');
                    $('#rtvt-content').css('border-radius', '10px');
                }
                
                if ($('.dl-menuopen').is(':visible') || $('.language-panel').length != 0) {
                    $('#rtvt-top-menu').removeClass('rtvt-top-menu-hidden');
                    $('#rtvt-content').css('border-radius', '0 0 10px 10px');
                }
                else {
                    if (!isMoveing) {
                        $('#rtvt-top-menu').addClass('rtvt-top-menu-hidden');
                        $('#rtvt-content').css('border-radius', '10px');
                    }
                }
            });
        }

        var select = $( "#minbeds" );
        sizeSlider = $( "<div id='slider'></div>" ).insertAfter( select ).slider({
            min: 1,
            max: 3,
            range: "min",
            value: select[ 0 ].selectedIndex + 1,
            slide: function( event, ui ) {
                if (!isLogin && event.originalEvent) {
                    updateSubtitleStyleAccess();
                    return false;
                }
                select[ 0 ].selectedIndex = ui.value - 1;

                globalConfig.textSize = 'size-l';
                if (ui.value == 1)
                    globalConfig.textSize = 'size-s';
                if (ui.value == 3)
                    globalConfig.textSize = 'size-xl';

                $('#rtvt-content').removeClass('size-s');
                $('#rtvt-content').removeClass('size-l');
                $('#rtvt-content').removeClass('size-xl');
                $('#rtvt-content').addClass(globalConfig.textSize);

                $('.rtvt-size-demo').removeClass('size-s');
                $('.rtvt-size-demo').removeClass('size-l');
                $('.rtvt-size-demo').removeClass('size-xl');
                $('.rtvt-size-demo').addClass(globalConfig.textSize);

                $('.rtvt-text-size-item').removeClass('sel-size');

                chrome.storage.local.set({ textSize : globalConfig.textSize }).then(() => {
                    //console.log("change and save text size");
                });

            }
        });
        $( "#minbeds" ).on( "change", function(event) {
            if (!isLogin && event.originalEvent) {
                updateSubtitleStyleAccess();
                return;
            }
			sizeSlider.slider( "value", this.selectedIndex + 1 );
        });

        // 透明度滑块（与字体大小一致的滑动交互，仅打印日志）
        var opacitySelect = $( "#opacity-select" );
        opacitySlider = $( "<div id='opacity-slider'></div>" ).insertAfter( opacitySelect ).slider({
            min: 1,
            max: 4,
            range: "min",
            value: (function(){
                var v = 2;
                var p = parseInt(globalConfig.bgOpacity || 90, 10);
                if (p <= 40) v = 1; else if (p <= 60) v = 2; else if (p <= 80) v = 3; else v = 4;
                return v;
            })(),
            slide: function( event, ui ) {
                if (!isLogin && event.originalEvent) {
                    updateSubtitleStyleAccess();
                    return false;
                }
                // 1->40, 2->60, 3->80, 4->90
                const map = {1:40, 2:60, 3:80, 4:90};
                const percent = map[ui.value] || 60;
                //console.log('[RTVT] 透明度滑动选择: ' + percent + '%');
                // 设置透明度
                // background: rgba(21, 21, 21, 0.9) ;
                $('#rtvt-content').css('background', 'rgba(21, 21, 21, ' + (percent / 100) + ')');
                // 设置背景透明度
                $('#rtvt-top-menu').css('background', 'rgba(21, 21, 21, ' + (percent / 100) + ')');
                globalConfig.bgOpacity = percent;
                chrome.storage.local.set({ bgOpacity: globalConfig.bgOpacity }).then(() => {});
            }
        });

        updateSubtitleStyleAccess();

        /*$('#rtvt-main-container').hover(
            function() {
                $('#rtvt-top-menu').removeClass('rtvt-top-menu-hidden');
            },
            function() {
                $('#rtvt-top-menu').addClass('rtvt-top-menu-hidden');
            }
        );*/

        // 初始化后调用一次
        updateContentHeight();

        // 在initPage函数中,为源语言按钮添加点击事件
        $('#src-lang-btn').on('click', function(e) {
            // 未登录时，点击语言按钮跳转到登录页面
            if (!isLogin) {
                e.preventDefault();
                e.stopPropagation();
                sendLoginQuest();
                return;
            }
            handleLangBtnClick(e, 'src');
        });
        $('#dst-lang-btn').on('click', function(e) {
            // 未登录时，点击语言按钮跳转到登录页面
            if (!isLogin) {
                e.preventDefault();
                e.stopPropagation();
                sendLoginQuest();
                return;
            }
            handleLangBtnClick(e, 'dst');
        });
        
        // 点击其他地方关闭面板
        $(document).on('click', function(e) {
            if (!$(e.target).closest('.language-panel').length && !$(e.target).closest('#src-lang-btn').length) {
                $('.language-panel').remove();
            }
        });

        // 点击设置按钮时关闭language-panel；未登录时点击设置按钮跳转到登录页面
        $('.menu-icon-setting').on('click', function(e) {
            if (!isLogin) {
                // 仅触发登录，不阻止原有逻辑，保证菜单行为正常
                sendLoginQuest();
                return;
            }
            $('.language-panel').remove();
        });

        // 监听主容器大小变化
        $('#rtvt-main-container').on('resize', function() {
            updateLanguagePanelPosition();
            $('#rtvt-top-menu').removeClass('rtvt-top-menu-hidden');
            $('#rtvt-content').css('border-radius', '0 0 10px 10px');
        });

        // 某些网站需要手动阻止滚动事件(如：https://elevenlabs.io/app/dubbing)
        $(document).ready(function() {
            const $scrollContainer = $('#rtvt-content');
            
            if ($scrollContainer.length) {
              $scrollContainer.on('wheel', function(event) {
                // 阻止事件传播
                event.stopPropagation();
                event.preventDefault();
                
                // 手动控制滚动
                const scrollAmount = event.originalEvent.deltaY;
                $(this).scrollTop($(this).scrollTop() + scrollAmount);
              });
            }
        });

        $(function() {
            $('input[name="shadow"][value="None"]').prop('checked', true);
            $('input[name="shadow"]').on('change', function(event) {
                if (!isLogin && event && event.originalEvent) {
                    updateSubtitleStyleAccess();
                    return false;
                }
                const color = $(this).val();
                $('.rtvt-size-demo').removeClass('outlined-text-white');
                $('.rtvt-size-demo').removeClass('outlined-text-black');
                $('#rtvt-content').removeClass('outlined-text-white');
                $('#rtvt-content').removeClass('outlined-text-black');

                if (color == 'White') {
                    $('.rtvt-size-demo').addClass('outlined-text-white');
                    $('#rtvt-content').addClass('outlined-text-white');
                }
                else if (color == 'Black') {
                    $('.rtvt-size-demo').addClass('outlined-text-black');    
                    $('#rtvt-content').addClass('outlined-text-black');    
                }

                globalConfig.textShadow = color;

                chrome.storage.local.set({ textShadow : globalConfig.textShadow }).then(() => {
                });
                
            });
        });        
        
    }

    chrome.storage.local.get(["uid", "token"], function (result) {
        let time = Math.floor(Date.now() / 1000);
        if (result.uid != null) {
            globalConfig["uid"] = result.uid;
        }
        if (result && result.token && result.token.token) {
            if (result.token.expirationDate !== undefined && time < result.token.expirationDate) {
                if (result.token.uid != null && isNumeric(result.token.uid)) {
                    $('.menu-user-login-text').text(result.token.uid);
                    isLogin = true;
                    globalConfig["uid"] = result.token.uid;
                    if (globalConfig.uid == 0) {
                        uploadLog("uid", "chrome.storage.local.get uid is 0");
                    }
                    $('#logout-btn').show();
                    // $('#rtvt-top-login-btn').hide();
                    updateSubtitleStyleAccess();
                    updateLoginTooltip();
                } else {
                    // 用户未登录，显示登录提示
                    loginRequiredCardShow();
                //    $('#rtvt-top-login-btn').show();
                }
                //console.log("Received cookie from background:", response.token.value);
            }else {
                //console.log("Cookie expired.");
                // Cookie过期，显示登录提示
                loginRequiredCardShow();
            }
        } else {
            //console.log("Cookie not found or error occurred.");
            // 没有Cookie，显示登录提示
            loginRequiredCardShow();
        }
    });

    if (!isFullDelayInit) {
        isFullDelayInit = true;
        initFullscreenDelay();
    }
    
    // 初始化登录按钮tooltip
    updateLoginTooltip();
};

function logOut() {
    $('.menu-user-login-text').text('未登录');
    globalConfig.uid = generateUUID();
    chrome.storage.local.set({ uid : globalConfig.uid, token: null }).then(() => {
        //console.log("change and save text size");
    });

    const manifestData = chrome.runtime.getManifest();
    const version = manifestData.version;
    chrome.runtime.sendMessage(
        {
        action: "setCookie",
        version: version,
        uid: globalConfig.uid,
        }
    );
    isLogin = false;
    $('#logout-btn').hide();
    // 显示登录提示
    loginRequiredCardShow();
    pauseRecording(tabId);
}

function isNumeric(value) {
  return typeof value === 'number' || (
    typeof value === 'string' &&
    value.trim() !== '' &&
    !isNaN(value)
  );
}

// 处理语言按钮点击事件
function handleLangBtnClick(e, btnType) {
    let lang = sortLangs(globalLangs);
    e.preventDefault();
    e.stopPropagation();
    
    // 如果面板已存在则移除
    $('.language-panel').remove();
    
    // 先模拟点击rtvt-content区域
    const clickEvent = new MouseEvent('click', {
        bubbles: true,
        cancelable: true,
        view: window
    });
    document.getElementById('rtvt-content').dispatchEvent(clickEvent);
    
    // 触发document的click事件来关闭设置菜单
    $(document).trigger('click.dlmenu');
    
    // 创建语言选择面板
    const panel = $('<div class="language-panel"></div>');
    const panelInner = $('<div class="language-panel-inner"></div>');
    
    // 添加语言选项
    if (btnType === 'dst') {
        delete lang['auto'];
    }
    for (let key in lang) {
        const button = $(`<button data-code="${key}" ${(btnType === 'src' ? globalConfig.asrLang.key : globalConfig.altLang.key) === key ? 'class="active"' : ''}>${lang[key]}</button>`);
        button.on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            
            // 先更新UI
            const selectedCode = $(this).data('code');
            if (btnType === 'src') {
                if (globalConfig.asrLang.key == selectedCode) {
                    $('.language-panel').remove();
                    return;
                }
                globalConfig.asrLang = { key: selectedCode, value: lang[selectedCode] };
                uploadLog("changeLang", btnType + "lang btn click, select: " + selectedCode);
            } else {
                if (globalConfig.altLang.key == selectedCode) {
                    $('.language-panel').remove();
                    return;
                }
                globalConfig.altLang = { key: selectedCode, value: lang[selectedCode] };
                uploadLog("changeLang", btnType + "lang btn click, select: " + selectedCode);
            }
            $(`#${btnType}-lang-btn`).text(lang[key]);
            $('.language-panel').remove();
            
            // 使用setTimeout延迟执行可能导致页面重排的操作
            chrome.storage.local.set({ 
                [btnType === 'src' ? 'asrLang' : 'altLang']: { key: selectedCode, value: lang[selectedCode] }
            }).then(() => {
                setTimeout(() => {
                    reloadRTVTClient();
                }, 0);
            });
        });
        panelInner.append(button);
    }
    
    // 将面板添加到按钮下方
    const btnPos = $(`#${btnType}-lang-btn`).position();
    
    const pos = calculateLanguagePanelPosition();

    panel.css({
        top: btnPos.top + $(`#${btnType}-lang-btn`).outerHeight() + 14.5,
        left: pos
    });
    
    panel.append(panelInner);
    $('#rtvt-main-container').append(panel);
}



function closeClick() {  
    uploadLog("close", "close click");
    stopRecording(tabId);
    isLoading = false;

    // 资源销毁
    sizeSlider = null;
    opacitySlider = null;
    hasRated = false;
}

function generateUUID() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
      const r = Math.random() * 16 | 0;
      const v = c === 'x' ? r : (r & 0x3 | 0x8);
      return v.toString(16);
    });
}

function initOpacitySlider() {
    // 应用背景透明度到主内容与顶部菜单
    var p = parseInt(globalConfig.bgOpacity || 90, 10);
    var alpha = (p / 100);
    $('#rtvt-content').css('background', 'rgba(21, 21, 21, ' + alpha + ')');
    $('#rtvt-top-menu').css('background', 'rgba(21, 21, 21, ' + alpha + ')');

    // 同步滑块位置（如已初始化）
    if (opacitySlider && typeof opacitySlider.slider === 'function') {
        var v = 2;
        if (p <= 40) v = 1; else if (p <= 60) v = 2; else if (p <= 80) v = 3; else v = 4;
        opacitySlider.slider('value', v);
    }
}

function initConfigFromLocal(callback) {
    chrome.storage.local.get(['textShadow', 'asrLang', 'altLang', 'textSize', 'textColor', 'containerWidth', 'containerHeight', 
        'containerTop', 'containerLeft', 'uid', 'openSubtitle', 'openBall', 'bgOpacity', 'highlightCurrentTranslation'], function(result) {

        if (result.asrLang !== undefined) {
            //console.log("asrLang: ", result.asrLang);
            globalConfig.asrLang = result.asrLang;
        }

        let systemLang = chrome.i18n.getUILanguage();
        if (result.altLang !== undefined) {
            globalConfig.altLang = result.altLang;
        } else {
            if (systemLang == "zh_CN" || systemLang == "zh_TW") {
                systemLang = "zh";
            }
            if (globalLangs[systemLang] !== undefined) {
                globalConfig.altLang = systemLang;
            }
        }

        console.log("textshadow: ", result);
        if (result.textShadow !== undefined) {
            globalConfig.textShadow = result.textShadow;
            
        }
        document.querySelector('input[name="shadow"][value="' + globalConfig.textShadow + '"]').click();

        if (result.textSize !== undefined)
            globalConfig.textSize = result.textSize;

        if (result.textColor !== undefined)
            globalConfig.textColor = result.textColor;

        // 背景透明度（百分比），默认90
        if (result.bgOpacity !== undefined) {
            var p = parseInt(result.bgOpacity, 10);
            if (!isNaN(p)) {
                globalConfig.bgOpacity = p;
            }
        }

        if (result.containerWidth !== undefined)
            globalConfig.containerWidth = result.containerWidth;
    
        if (globalConfig.containerWidth < mainMinWidth) {
            globalConfig.containerWidth = mainMinWidth;
        }

        if (result.containerHeight !== undefined)
            globalConfig.containerHeight = result.containerHeight;

        if (result.containerTop !== undefined)
            globalConfig.containerTop = result.containerTop;

        if (result.containerLeft !== undefined)
            globalConfig.containerLeft = result.containerLeft;

        if (result.openSubtitle !== undefined)
            globalConfig.openSubtitle = result.openSubtitle;

        if (result.openBall !== undefined)
            globalConfig.openBall = result.openBall;

        if (result.highlightCurrentTranslation !== undefined)
            globalConfig.highlightCurrentTranslation = result.highlightCurrentTranslation;

        if (result.uid !== undefined) {
            globalConfig.uid = result.uid;
        } else {
            globalConfig.uid = generateUUID();
            chrome.storage.local.set({ uid : globalConfig.uid }).then(() => {
                //console.log("change and save text size");
            });
        }

        const manifestData = chrome.runtime.getManifest();
        const version = manifestData.version;

        chrome.runtime.sendMessage(
            {
              action: "setCookie",
              version: version,
              uid: globalConfig.uid,
            },
            // function(response) {
            //   if (response.success) {
            //     console.log("Cookie set successfully!");
            //   } else {
            //     console.error("Failed to set cookie:", response.error);
            //   }
            // }
        );

        $('#rtvt-asr-lang-show').text(globalConfig.asrLang.value);
        $('#rtvt-alt-lang-show').text(globalConfig.altLang.value);

        $('#rtvt-content').removeClass('white');
        $('#rtvt-content').removeClass('yellow');
        $('#rtvt-content').removeClass('green');
        $('#rtvt-content').addClass(globalConfig.textColor);

        $('.rtvt-size-demo').removeClass('white');
        $('.rtvt-size-demo').removeClass('yellow');
        $('.rtvt-size-demo').removeClass('green');
        $('.rtvt-size-demo').addClass(globalConfig.textColor);

        $('.rtvt-text-color-item').removeClass('sel-color');
        $('.rtvt-color-' + globalConfig.textColor).addClass('sel-color');

        $('#rtvt-content').removeClass('size-s');
        $('#rtvt-content').removeClass('size-l');
        $('#rtvt-content').removeClass('size-xl');
        $('#rtvt-content').addClass(globalConfig.textSize);

        // 初始化背景透明度
        initOpacitySlider();

        $('.rtvt-size-demo').removeClass('size-s');
        $('.rtvt-size-demo').removeClass('size-l');
        $('.rtvt-size-demo').removeClass('size-xl');
        $('.rtvt-size-demo').addClass(globalConfig.textSize);

        $('.rtvt-text-size-item').removeClass('sel-size');
        if (globalConfig.textSize == 'size-s') {
            $('.ss-s').addClass('sel-size');
            sizeSlider.slider( "value", 1 );
        }
        if (globalConfig.textSize == 'size-l') {
            $('.ss-l').addClass('sel-size');
            $("#minbeds")[0].selectedIndex = 2;
            sizeSlider.slider( "value", 2 );
        }
        if (globalConfig.textSize == 'size-xl') {
            $('.ss-xl').addClass('sel-size');
            $("#minbeds")[0].selectedIndex = 3;
            sizeSlider.slider( "value", 3 );
        }
        

        $('#rtvt-main-container').width(globalConfig.containerWidth);
        $('#rtvt-main-container').height(globalConfig.containerHeight);

        $('#rtvt-main-container').css('left',  globalConfig.containerLeft);
        $('#rtvt-main-container').css('top', globalConfig.containerTop);

        if (globalConfig.openSubtitle == 1 || globalConfig.openSubtitle == '1') {
            $('#subtitle-check').prop('checked', true);
        } else {
            $('#subtitle-check').prop('checked', false);
        }

        if (globalConfig.openBall == 1 || globalConfig.openBall == '1') {
            $('#ball-check').prop('checked', true);
        } else {
            $('#ball-check').prop('checked', false);
        }

        if (globalConfig.highlightCurrentTranslation == 1 || globalConfig.highlightCurrentTranslation == '1') {
            $('#highlight-check').prop('checked', true);
        } else {
            $('#highlight-check').prop('checked', false);
        }

        $(window).resize(function() {
            const windowWidth = $(window).width();
            const windowHeight = $(window).height();
            const minWidth = mainMinWidth;
            const minHeight = mainMinHeight;
            //console.log("resize", windowWidth, windowHeight);
            
            let left = globalConfig.containerLeft;
            let top = globalConfig.containerTop;
            let width = globalConfig.containerWidth;
            let height = globalConfig.containerHeight;
            let needUpdate = false;

            // 处理宽度和水平位置
            if (left + width > windowWidth) {
                // 先尝试移动位置
                left = windowWidth - width;
                
                // 如果移动后左边超出范围，则需要调整宽度
                if (left < 0) {
                    width = Math.max(minWidth, windowWidth);
                    left = 0;
                }
                needUpdate = true;
            }

            // 处理高度和垂直位置
            if (top + height > windowHeight) {
                // 先尝试移动位置
                top = windowHeight - height - 20; // 留出底部边距
                
                // 如果移动后顶部超出范围，则需要调整高度
                if (top < 0) {
                    height = Math.max(minHeight, windowHeight - 20);
                    top = 0;
                }
                needUpdate = true;
            }

            // 应用更新
            if (needUpdate) {
                if (width !== globalConfig.containerWidth) {
                    globalConfig.containerWidth = width;
                    $('#rtvt-main-container').width(width);
                }
                if (height !== globalConfig.containerHeight) {
                    globalConfig.containerHeight = height;
                    $('#rtvt-main-container').height(height);
                }
                if (left !== globalConfig.containerLeft) {
                    globalConfig.containerLeft = left;
                    $('#rtvt-main-container').css('left', left);
                }
                if (top !== globalConfig.containerTop) {
                    globalConfig.containerTop = top;
                    $('#rtvt-main-container').css('top', top);
                }
                saveContainerPosition();
            }
            updateContentHeight();

            updateLanguagePanelPosition();
        });
 
        // 获取保存的语言设置并更新按钮文本
        chrome.storage.local.get(['asrLang', 'altLang'], function(result) {
            initAutoSelectLanguage();
        });

        if (systemLang != "zh-CN" && systemLang != "zh-TW") {
            $('.dl-menuwrapper .dl-menu').css('width', '285px');
            $('.ball-switch').css('margin-left', '5px');
            $('#src-lang-btn').css('font-size', '13px');
            $('#src-lang-btn').css('line-height', '13px');
            $('#dst-lang-btn').css('font-size', '13px');
            $('#dst-lang-btn').css('line-height', '13px');

            $('.rtvt-top-login-link').css('min-width', '75px');
            
            console.log("systemLang: ", systemLang);
        }
        
        if (systemLang == "ar") {
            $('.rtvt-text-shadow label').css({
                'display': 'inline-flex',
                'flex-direction': 'row-reverse',
                'align-items': 'center',
                'gap': '6px'
            });
        }
        else {
            $('.rtvt-text-shadow label').css({
                'display': '',
                'flex-direction': '',
                'align-items': '',
                'gap': ''
            });
        }

        callback();
        updateLanguagePanelPosition();
    });
}

function sortLangs(dataLangs) {
    let sortedLangs = {};
    
    if(dataLangs.hasOwnProperty('auto')) {
        sortedLangs['auto'] = dataLangs['auto'];
    }
    
    languageOrder.forEach(langCode => {
        if(langCode !== 'auto' && dataLangs.hasOwnProperty(langCode)) {
            sortedLangs[langCode] = dataLangs[langCode];
        }
    });
    
    // 剩余未在 languageOrder 中的项
    Object.keys(dataLangs).forEach(langCode => {
        if(langCode !== 'auto' && !languageOrder.includes(langCode)) {
            sortedLangs[langCode] = dataLangs[langCode];
        }
    });
    
    return sortedLangs;
}

function updateConfig(callback) {

    $('#rtvt-lang-list-alt').find('.alt-lang-pitem').remove();
    $('#rtvt-lang-list-asr').find('.alt-lang-pitem').remove();

        initConfigFromLocal(function() {
        chrome.storage.local.get(["uid", "token"], function (result) {
            // 未登录判断
            if (result.token == undefined || result.token.uid == undefined || result.token.uid.includes("-")) {
                console.log("not login");
                setDonateIconUnpaid();
                // 显示登录提示
                loginRequiredCardShow();
                return;
            }

            // 修改为使用viitor的gettoken接口
            let lang = chrome.i18n.getMessage("lang");
            if (lang == "en") {
                lang = "en-US"
            }
            if (lang == "zh_CN" || lang == "zh_TW") {
                lang = "zh-CN"
            }
            let url = 'https://rtvt-cn-app.ilivedata.com/service/chrome/getrtvttoken';
            let data = {
                lang: lang,
                uid: result.token.uid,
                token: result.token.token,
                product: "rtvt",
                platform: "chrome",
                deviceId: ""
            }

            let old_uid = result.token.uid;

            // 先初始化语言
            initAutoSelectLanguage();

            ajaxRequest(url, 'post', JSON.stringify(data), 3000, {
                //ajaxRequest(apiHost + "?lang=" + chrome.i18n.getMessage("lang") + "&ver=new", 'post', {}, 3000, {

        dataType: 'json',
        success: function(data) {

                    if (data.code != 0) {
                        uploadLog("getToken", "gettoken result: " + JSON.stringify(data), old_uid);
                        // 登录过期
                        logOut();
                return;
                    }

                    globalConfig["uid"] = result.token.uid;
                    uploadLog("getToken", "gettoken success data: " + JSON.stringify(data));
                    updateDonateIconByVipStatus(result.token.uid, result.token.token);

                    data.langs = {};
                    for (let key in data.info) {
                        if (data.info[key]["Name"] == "中文普通话") {
                            data.info[key]["Name"] = "中文";
                        }
                        data.langs[key] = data.info[key]["Name"];
                    }

                    //console.log(data.langs);

            globalLangs = {
                'auto': chrome.i18n.getMessage("autodetect")
            };
            globalLangs = Object.assign(globalLangs, data.langs);

                    // 更新语言
                    initAutoSelectLanguage();

                    callback(parseInt(data.pid), data.token, parseInt(data.ts), "wss://" + data.endpoint);
        },
        complete: function(jqXHR, textStatus) {
                    //console.log("updateConfig complete", jqXHR, textStatus);

            //initConfigFromLocal(function() {

                let tmpLangs = sortLangs(globalLangs);

                for (var i in tmpLangs) {

                    let selAltLang = '';
                    if (i == globalConfig.altLang.key) {
                        selAltLang = '<span class="selec-icon"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="none" version="1.1" width="20" height="20" viewBox="0 0 20 20"><defs><clipPath id="master_svg0_1299_48098"><rect x="0" y="0" width="20" height="20" rx="0"/></clipPath></defs><g clip-path="url(#master_svg0_1299_48098)"><g><path d="M7.91675390625,15.47330390625L1.85175390625,7.74579390625C1.52319390625,7.41785390625,0.99114990625,7.41785390625,0.66258890625,7.74579390625C0.33447570625,8.07330390625,0.33447570625,8.60494390625,0.66258890625,8.93245390625L7.32259390625,17.254103906250002C7.65029390625,17.583303906250002,8.18322390625,17.583303906250002,8.51092390625,17.254103906250002L19.33760390625,3.09912390625C19.66570390625,2.77161390625,19.66570390625,2.23997090625,19.33760390625,1.91245790625C19.00900390625,1.58451940625,18.47700390625,1.58451940625,18.14840390625,1.91245790625L7.91675390625,15.47330390625Z" fill="#FFFFFF" fill-opacity="1" style="mix-blend-mode:passthrough"/></g></g></svg></span>';
                    }

                    if (i !== 'auto') {
                        $('#rtvt-lang-list-alt').append('<li class="alt-lang-pitem"><a href="javascript:void(0);" class="rtvt-menu-lang-item" value="' + i + '"><span class="sel-name">' + tmpLangs[i] + '</span>' + selAltLang + '</a></li>');
                    }

                    let selAsrLang = '';
                    if (i == globalConfig.asrLang.key) {

                        selAsrLang = '<span class="selec-icon"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="none" version="1.1" width="20" height="20" viewBox="0 0 20 20"><defs><clipPath id="master_svg0_1299_48098"><rect x="0" y="0" width="20" height="20" rx="0"/></clipPath></defs><g clip-path="url(#master_svg0_1299_48098)"><g><path d="M7.91675390625,15.47330390625L1.85175390625,7.74579390625C1.52319390625,7.41785390625,0.99114990625,7.41785390625,0.66258890625,7.74579390625C0.33447570625,8.07330390625,0.33447570625,8.60494390625,0.66258890625,8.93245390625L7.32259390625,17.254103906250002C7.65029390625,17.583303906250002,8.18322390625,17.583303906250002,8.51092390625,17.254103906250002L19.33760390625,3.09912390625C19.66570390625,2.77161390625,19.66570390625,2.23997090625,19.33760390625,1.91245790625C19.00900390625,1.58451940625,18.47700390625,1.58451940625,18.14840390625,1.91245790625L7.91675390625,15.47330390625Z" fill="#FFFFFF" fill-opacity="1" style="mix-blend-mode:passthrough"/></g></g></svg></span>';
                    }

                    $('#rtvt-lang-list-asr').append('<li class="alt-lang-pitem"><a href="javascript:void(0);" class="rtvt-menu-lang-item" value="' + i + '"><span class="sel-name">' + tmpLangs[i] + '</span>' + selAsrLang + '</a></li>');
                }

                $('#rtvt-lang-list-alt').find('.rtvt-menu-lang-item').on('click', function() {
                    $('body').trigger('click');

                    var lang = $(this).attr('value');
                    var text = globalLangs[lang];
                    if (lang == 'none')
                        $('#rtvt-alt-lang-show').text(chrome.i18n.getMessage("close"));
                    else {
                        $('#rtvt-alt-lang-show').text(text);
                    }
                    globalConfig.altLang = { key: lang, value: text };

                    chrome.storage.local.set({ altLang : globalConfig.altLang }).then(() => {
                        reloadRTVTClient();
                    });
                });

                $('#rtvt-lang-list-asr').find('.rtvt-menu-lang-item').on('click', function() {
                    $('body').trigger('click');

                    var lang = $(this).attr('value');
                    var text = globalLangs[lang];
                    $('#rtvt-asr-lang-show').text(text);
                    globalConfig.asrLang = { key: lang, value: text };

                    //console.log("updateConfig asrLang: ", globalConfig.asrLang);
                    chrome.storage.local.set({ asrLang : globalConfig.asrLang }).then(() => {
                        reloadRTVTClient();
                    });
                });
            //});
        },
        error: function(jqXHR, textStatus, errorThrown) {
                    // logOut();  //是否应该退出登录？
            console.error("update config error");
            console.log(jqXHR);
            console.log(textStatus);
            console.log(errorThrown);
        }
    });
        });
    });
}

function getSignature(text) {
    return CryptoJS.MD5(text).toString();
}

function formatTimestamp(timestamp) {
    const date = new Date(timestamp);
  
    const Y = date.getFullYear();
    const M = String(date.getMonth() + 1).padStart(2, '0');
    const D = String(date.getDate()).padStart(2, '0');
  
    const h = String(date.getHours()).padStart(2, '0');
    const m = String(date.getMinutes()).padStart(2, '0');
    const s = String(date.getSeconds()).padStart(2, '0');
    const ms = String(date.getMilliseconds()).padStart(3, '0');
  
    return `${Y}-${M}-${D} ${h}:${m}:${s}.${ms}`;
  }

function getUTCTimeFormat(timestamp) {
    const date = new Date(timestamp);
    const Y = date.getUTCFullYear();
    const M = String(date.getUTCMonth() + 1).padStart(2, '0');
    const D = String(date.getUTCDate()).padStart(2, '0');
    const h = String(date.getUTCHours()).padStart(2, '0');
    const m = String(date.getUTCMinutes()).padStart(2, '0');
    const s = String(date.getUTCSeconds()).padStart(2, '0');
    const ms = String(date.getUTCMilliseconds()).padStart(3, '0');
    return `${Y}-${M}-${D} ${h}:${m}:${s}.${ms}`;
}

function uploadLog(event_id, log, uid = null) {
    if (uid == null && (globalConfig["uid"] == undefined || globalConfig["uid"] == "0")) {
        chrome.storage.local.get(['uid'], function(result) {
            if (result.uid !== undefined) {
                globalConfig["uid"] = result.uid;
            } 
            realUploadLog(event_id, log);
        });
    }
    else {
        realUploadLog(event_id, log, uid);
    }
}

function getBrowserInfo() {
    const userAgent = navigator.userAgent;
    if (userAgent.indexOf("Firefox") > -1) {
        return "Firefox";
    } else if (userAgent.indexOf("Chrome") > -1 && userAgent.indexOf("Edg") == -1) {
        return "Chrome";
    } else if (userAgent.indexOf("Edg") > -1) {
        return "Edge";
    } else if (userAgent.indexOf("Safari") > -1 && userAgent.indexOf("Chrome") == -1) {
        return "Safari";
    } else if (userAgent.indexOf("MSIE") > -1 || userAgent.indexOf("Trident") > -1) {
        return "Internet Explorer";
    } else {
        return userAgent;
    }
}

function uploadDonateLog(uid) {
    let browserInfo = getBrowserInfo();
    data = {
        "base" : {
            "appVersion": chrome.runtime.getManifest().version,
            "product": "rtvt_chrome_extension",
            "os": browserInfo,
            "level": "info",
            "app_background": false,
            "pid": PID,
            "systemVersion": navigator.userAgent,
            "deviceId": "",
            "userId": uid,
            "platform": "Chrome",
            "manufacturer": "",
            "machineModel": "",
            "networkType": ""
        },
        "event": {
            "eventName": "vip_bt_click",
            "eventScene": "showSupportUsDialog",
            "eventTime": Date.now(),
            "eventTimeDate": new Date().toLocaleString()
        }
    };
    realUploadLog("vip_bt_click", "", uid, JSON.stringify(data));
}

function realUploadLog(event_id, log, uid = null, data = null) {
    if (uid == null) {
        uid = globalConfig["uid"];
    }
    setTimeout(() => {
        if (data == null) {
            let browserInfo = getBrowserInfo();
            data = {
                "base" : {
                    "appVersion": chrome.runtime.getManifest().version,
                    "product": "rtvt_chrome_extension",
                    "os": browserInfo,
                    "level": "info",
                    "app_background": false,
                    "pid": PID,
                    "systemVersion": navigator.userAgent,
                    "deviceId": "",
                    "userId": uid,
                    "platform": "Chrome",
                    "manufacturer": "",
                    "machineModel": "",
                    "networkType": ""
                },
                "event": {
                    "log" : log,
                    "eventName": event_id,
                    "eventScene": event_id,
                    "eventTime": Date.now(),
                    "eventTimeDate": new Date().toLocaleString()
                }
            };
            data = JSON.stringify(data);
        }

        let ts = Math.floor(Date.now() / 1000).toString();
        let url = "https://httpagent.viitor.info/log?pid=0&tag=viitor.client.log&timestamp=" 
            + ts + "&signature=" + getSignature("0:viitor.client.log:" + "65x38jsybcfjs87625609dj6bfc3i83y:" + ts);

        $.ajax({
            type: "POST",
            url: url,
            data: data,
            contentType: "text/plain",
            success: function(response) {
                //console.log('upload log Response:', response);
            },
            error: function(xhr, status, error) {
                console.error('upload log Error:', error);
            }
        });

    }, 0);
}

// 点赞点踩反馈
function feedback_function(data) {
    setTimeout(() => {
        let url = "https://rtvt-cn-app.ilivedata.com/feedback/function";

        $.ajax({
            type: "POST",
            url: url,
            data: JSON.stringify(data),
            contentType: "text/plain",
            success: function(response) {
                console.log('feedback_function Response:', response);
            },
            error: function(xhr, status, error) {
                console.error('feedback_function Error:', error);
            }
        });
    }, 0);
}

function isSupportWorker() {
    let notSupported = [];
    let supportWorker = true;
    for (let i = 0; i < notSupported.length; i++) {
        if (window.location.href.indexOf(notSupported[i]) > -1) {
            supportWorker = false;
            break;
        }
    }
    return supportWorker;
}

function reloadRTVTClient() {
    initRTVTClient(true);
}

let isRestart = false;
function initRTVTClient(reset = false) {
    if (isSupportWorker()) {
        initRTVTClient2();
    }
    else {
        initRTVTClient1(reset);
    }
}

function initRTVTClient1(reset = false) {
    if (rtvtClient === null || reset) {
        globalSeg = 0;
        if (rtvtClient !== null) {
            rtvtClient.destory();
            rtvtClient = null;
        }

        updateConfig(function(pid, token, ts, endpoint) {

            rtvtClient = new RTVTClient({
                endpoint: endpoint,
                pid: pid,
                uid: globalConfig.uid,
            });

            rtvtClient.on("ReloginCompleted", function(ok, errorCode) {
                console.log("ReloginCompleted, ok: " + ok + " errorCode: " + errorCode);
            });
    
            rtvtClient.on("ErrorRecorder", function(error) {
                console.log(error);
                if (error.code == 800002 && !isRestart) {
                    isRestart = true;
                    //console.log("restart rtvt client");
                    pauseRecording(tabId);
                    setTimeout(() => {
                        //console.log("resume rtvt client1");
                        resumeRecording(tabId);
                        isRestart = false;
                    }, 1000);
                }
            });
    
            uploadLog("rtvtLogin", "request rtvtClient login");
            rtvtClient.login(token, ts, async function(ok, errorCode) {
                let log = "rtvtClient login result: " + ok + " errorCode: " + errorCode;
                uploadLog("rtvtLogin", log);
                console.log("login: ", ok, " errorCode: ", errorCode);
                //console.log(errorCode);
                
                if (!ok) {
                    console.log("login fail: " + errorCode);
                    // TODO
                    return;
                }

                needAlt = true;
                if (globalConfig.altLang == 'none')
                    needAlt = false;
    
                rtvtClient.createStream(globalConfig.uid, globalConfig.asrLang.key, globalConfig.altLang.key, true, true, needAlt, async function(stream, errorCode) {
                    if (stream == null) {
                        console.log("create stream fail: " + errorCode);
                        uploadLog("createStream", "create stream fail: " + errorCode);
                        // TODO
                        return;
                    }
    
                    uploadLog("createStream", "create stream id: " + stream._id);

                    rtvtStream = stream;
    
                    rtvtClient.on("recognizedResult", function(data) {
                        //console.log(data);
                        hasPermission = true;
                        $('.no-permission-div').hide();
                        let autoScroll = true;
                        if ($('#rtvt-content').scrollTop() + $('#rtvt-content').height() + 40 + scrollFactor < $('#rtvt-content').prop('scrollHeight')) {
                            autoScroll = false;
                        }
    
                        if ($('#rtvt-result-' + data.streamId + '-' + data.taskId).length == 0) {
                            $('.rtvt-tmp-result').attr('id', 'rtvt-result-' + data.streamId + '-' + data.taskId);
                            $('#rtvt-result-' + data.streamId + '-' + data.taskId).removeClass('rtvt-tmp-result');
    
                            $('#rtvt-content').append('<div class="rtvt-result-div rtvt-tmp-result"><div class="rtvt-asr-result"></div><div class="rtvt-alt-result"></div></div>');
                        }

                        if (globalConfig.openSubtitle == 1) {
                            $('#rtvt-result-' + data.streamId + '-' + data.taskId).find('.rtvt-asr-result').text(data.asr);
                        }
                        
                        if (autoScroll) {
                            $('#rtvt-content').scrollTop($('#rtvt-content')[0].scrollHeight);
                        }
                        
                    });
    
                    rtvtClient.on("recognizedTempResult", function(data) {
                        //console.log(data);
                        hasPermission = true;
                        $('.no-permission-div').hide();
                        let autoScroll = true;
                        if ($('#rtvt-content').scrollTop() + $('#rtvt-content').height() + 40 + scrollFactor < $('#rtvt-content').prop('scrollHeight')) {
                            autoScroll = false;
                        }
    
                        if ($('.rtvt-tmp-result').length == 0) {
                            $('#rtvt-content').append('<div class="rtvt-result-div rtvt-tmp-result"><div class="rtvt-asr-result"></div><div class="rtvt-alt-result"></div></div>');
                        }
    
                        if (globalConfig.openSubtitle == 1) {
                            $('.rtvt-tmp-result').find('.rtvt-asr-result').text(data.asr);
                        }

                        if (autoScroll) {
                            $('#rtvt-content').scrollTop($('#rtvt-content')[0].scrollHeight);
                        }
                    });
    
                    rtvtClient.on("translatedResult", function(data) {
                        //console.log(data);
                        hasPermission = true;
                        $('.no-permission-div').hide();
                        let autoScroll = true;
                        if ($('#rtvt-content').scrollTop() + $('#rtvt-content').height() + 40 + scrollFactor < $('#rtvt-content').prop('scrollHeight')) {
                            autoScroll = false;
                        }
                        
                        $('#rtvt-result-' + data.streamId + '-' + data.taskId).find('.rtvt-alt-result').text(data.trans);
                        
                        // 翻译完成时移除高亮样式
                        $('#rtvt-result-' + data.streamId + '-' + data.taskId).find('.rtvt-alt-result').removeClass('size-xxl');
    
                        if (autoScroll) {
                            $('#rtvt-content').scrollTop($('#rtvt-content')[0].scrollHeight);
                        }
                    });

                    rtvtClient.on("translatedTempResult", function(data) {
                        $('.no-permission-div').hide();
                        hasPermission = true;
                        let autoScroll = true;
                        if ($('#rtvt-content').scrollTop() + $('#rtvt-content').height() + 40 + scrollFactor < $('#rtvt-content').prop('scrollHeight')) {
                            autoScroll = false;
                        }
    
                        if (globalConfig.openSubtitle == 1 && $('.rtvt-tmp-result').find('.rtvt-asr-result').text().length > 0) {
                            $('.rtvt-tmp-result').find('.rtvt-alt-result').text(data.trans);
                        } else if (globalConfig.openSubtitle == 0) {
                            $('.rtvt-tmp-result').find('.rtvt-alt-result').text(data.trans);
                        }
    
                        // 高亮当前翻译：如果开关打开，添加样式
                        if (globalConfig.highlightCurrentTranslation == 1 || globalConfig.highlightCurrentTranslation == '1') {
                            $('.rtvt-tmp-result').find('.rtvt-alt-result').addClass('size-xxl');
                        }
    
                        if (autoScroll) {
                            $('#rtvt-content').scrollTop($('#rtvt-content')[0].scrollHeight);
                        }
                    });

    
                });
    
            });
        });
    }
}

function initRTVTClient2() {
    chrome.runtime.sendMessage({cmd: 'stop', tabId: tabId });

    updateConfig(function(pid, token, ts, endpoint) {
        console.log("worker postMessage");
        uploadLog("rtvtLogin", "request rtvtClient login");
        PID = pid;
        chrome.runtime.sendMessage({
            cmd: 'start', 
            data: {
                endpoint: endpoint,
                pid: pid,
                globalConfig: globalConfig,
                token: token,
                ts: ts,
                tabId: tabId
            },
            tabId: tabId
        });
    });
}

function startRTVTClient() {
    chrome.runtime.sendMessage({
        workerStart: true,
        tabId: tabId,
    });
    isCapture = true;
}

function uploadLoginLog(loginStatus, uid, result, log = "") {
    let browserInfo = getBrowserInfo();
    let data = {
        "base" : {
            "appVersion": chrome.runtime.getManifest().version,
            "product": "rtvt_chrome_extension",
            "os": browserInfo,
            "level": "info",
            "app_background": false,
            "pid": PID,
            "systemVersion": navigator.userAgent,
            "deviceId": "",
            "userId": uid,
            "platform": "Chrome",
            "manufacturer": "",
            "machineModel": "",
            "networkType": ""
        },
        "event": {
            "log" : log,
            "eventName": loginStatus,
            "eventScene": "login",
            "eventParameter": {
                "errorType":"",
                "loginType":result.data.login_type.toUpperCase() || "UNKNOWN",
                "requestType": "API",
                "code": 0,
                "result": "login success"
            },
            "eventTime": Date.now(),
            "eventTimeDate": new Date().toLocaleString()
        }
    }

    if (loginStatus == "loginFailed") {
        data.base.level = "error";
        data.base.pid = "0";
        data.event.eventParameter.result = result.data.errorMessage || "login failed";
        data.event.eventParameter.errorType = result.data.errorMessage || "login failed";
        data.event.eventParameter.code = result.data.response.status || -1;
    }

    realUploadLog("", "", uid, JSON.stringify(data));
}

chrome.runtime.onMessage.addListener(async (request) => {
    if (request.contentStart) {
        initPage();
        initRTVTClient();

        tabId = request.tabId;

        startRTVTClient();

    } else if (request.pcmData) {
        if (!isSupportWorker()) {
            if (rtvtClient !== null) { 
                // console.log("sendVoice");
                const pcmData = (new Int16Array(request.pcmData)).buffer;
                rtvtClient.sendVoice(rtvtStream, globalSeg++, pcmData);

                // const pcmData = new Int16Array(request.pcmData);
                // pcmDataMap.set(globalSeg, pcmData);
                // postMessage(globalSeg++);
            }
        }
        else {
            //if (worker !== null) { 
                //const pcmData = (new Int16Array(request.pcmData)).buffer;
                //console.log("sendVoice", request.pcmData)
                chrome.runtime.sendMessage({
                    cmd: 'sendVoice',
                    pcmData: request.pcmData,
                    tabId: tabId
                });
                //console.log("sendVoice", Date.now(), pcmData.byteLength);

            //}
        }
    } else if (request.stopTab) {
        stopRecording(tabId);
        uploadLog("captureAudio", "stop recording");
    } else if (request.noPermission) {
        console.log("request.noPermission", request);
        uploadLog("captureAudio", request.ex);
        setTimeout(() => {
            if (!hasPermission) {
                $('.no-permission-div').show();
            }
        }, 5000);
    } else if (request.changePermission) {
        uploadLog("captureAudio", "start recording success");
        console.log("request.changePermission");
        hasPermission = true;
        $('.no-permission-div').hide();
    }
    else if (request.loginStatus) {          
        let loginResult = request.data;
       
        if (loginResult.type == "LOGIN_FAILED") {
            uploadLoginLog("loginFailed", globalConfig["uid"], request.data);
            return;
        }

        uploadLoginLog("loginSuccess", request.data.data.uid, request.data);

        isLogin = true;
        $('#logout-btn').show();
        $('.menu-user-login-text').text(request.data.data.uid);
        // $('#rtvt-top-login-btn').hide();
        updateSubtitleStyleAccess();
        updateLoginTooltip();
        uploadLog("userLogin", "user login success, data: " + JSON.stringify(request.data.data), globalConfig["uid"]);
        // 过期时间30天
        request.data.data.expirationDate = (Date.now()/1000) + 30*24*60*60;
        globalConfig["uid"] = request.data.data.uid;
        chrome.storage.local.set({ uid : request.data.data.uid, token : request.data.data }).then(() => {
            //console.log("change and save text size");
        });

        // 隐藏登录提示
        loginRequiredCardHide();
        // 根据 VIP 状态更新捐赠图标
        updateDonateIconByVipStatus(request.data.data.uid, request.data.data.token || request.data.data);
        // 开启音频并初始化RTVTClient
        resumeRecording(tabId);
    }
    else if (request.payFinish) {

        let payData = request.data.data;
        if (payData.code == 0) {
            console.log("payFinish success", payData);
            const donateThanksStr = chrome.i18n.getMessage("donate_thanks_toast");
            showToast(donateThanksStr || "您已经成为会员!", 30000, '#rtvt-content', true, false);
            chrome.storage.local.get(["uid", "token"], function (result) {
                updateDonateIconByVipStatus(result.token.uid, result.token.token);
            });
        }
    }
    else {
        //console.log("worker onmessage", request);
        workerOnmessage(request);
    }
});
  
function initAutoSelectLanguage() {
    const lang = sortLangs(globalLangs);
    // 判断lang为null 或者 {}的情况
    if (lang == null || Object.keys(lang).length == 0) {
        $('#src-lang-btn').text(chrome.i18n.getMessage("recoglang"));
        $('#dst-lang-btn').text(chrome.i18n.getMessage("translang"));
        return lang;
    }
    //console.log("-------lang", lang, globalConfig);
    // 判断globalConfig.asrLang是否为字符串（兼容老方式），如果是则使用lang[globalConfig.asrLang]，否则使用globalConfig.asrLang.value
    let srcLang = '';
    if (typeof globalConfig.asrLang == 'object') {
        srcLang = lang[globalConfig.asrLang.key];
        //srcLang = globalConfig.asrLang.value;
    } else if (typeof globalConfig.asrLang == 'string') {
        srcLang = lang[globalConfig.asrLang];
        globalConfig.asrLang = {
            key: globalConfig.asrLang,
            value: srcLang
        }
    }
    let dstLang = '';
    if (typeof globalConfig.altLang == 'object') {
        dstLang = lang[globalConfig.altLang.key];
        //dstLang = globalConfig.altLang.value;
    } else if (typeof globalConfig.altLang == 'string') {
        dstLang = lang[globalConfig.altLang];
        globalConfig.altLang = {
            key: globalConfig.altLang,
            value: dstLang
        }
    }
    
    //console.log("-------srcLang", srcLang, dstLang, globalConfig);
    $('#src-lang-btn').text(srcLang || lang['auto']);
    $('#dst-lang-btn').text(dstLang || lang['en']);

    return lang;
}

  
var stopRecording = function(tabId) {
    // 取消resize事件监听
    $(window).off('resize');

    // 关闭插件界面时，同时清理可能残留在网页上的 toast
    removeAllToasts();
    $('#rtvt-main-container').remove();
    pauseRecording(tabId);
};

var pauseRecording = function(tabId, isRtvtStop = true) {
    console.log(isRtvtStop);
    if (isRtvtStop) {
        if (!isSupportWorker()) {
            if (rtvtClient !== null) {
                rtvtClient.destory();
                rtvtClient = null;
            }
        }
        else {
            chrome.runtime.sendMessage({cmd: 'stop', tabId: tabId });
        }
    }
    chrome.runtime.sendMessage({
        type: 'stop-recording',
        target: 'offscreen',
        tabId: tabId
    });
    isCapture = false;
}

var resumeRecording = function(tabId, isRtvtStop = true) {
    if (isRtvtStop) {
        initRTVTClient();
    }

    chrome.runtime.sendMessage({
        workerResume: true,
        tabId: tabId,
    });
    isCapture = true;
}

// 视频网站全屏调整注入结构
$(document).ready(function () {

    $(document).on('fullscreenchange webkitfullscreenchange mozfullscreenchange msfullscreenchange', function () {
        const fullscreenElement =
          document.fullscreenElement ||
          document.webkitFullscreenElement ||
          document.mozFullScreenElement ||
          document.msFullscreenElement;
    
        if (fullscreenElement) {
          const $injectedDiv = $('#rtvt-main-container');
    
          if ($injectedDiv.length > 0) {
            const $originalParent = $injectedDiv.parent();
            $injectedDiv.data('original-parent', $originalParent);
    
            $(fullscreenElement).append($injectedDiv);
          }
        } else {
          const $injectedDiv = $('#rtvt-main-container');
    
          if ($injectedDiv.length > 0) {
            const $originalParent = $injectedDiv.data('original-parent');
    
            if ($originalParent) {
              $originalParent.append($injectedDiv);
            }
          }
        }
      });

});

// 计算language-panel的位置
function calculateLanguagePanelPosition() {
    // 计算主页面的位置
    const mainContainer = $('#rtvt-main-container');
    const mainContainerLeft = mainContainer.offset().left;

    // 计算arrow-right的位置
    const arrowRight = $('#arrow-right');
    
    if (!arrowRight.length || !arrowRight.offset().left) {
        // 如果arrow-right不存在或坐标为空，使用默认位置
        const containerWidth = mainContainer.width();
        return containerWidth / 2 - 144.5; // 289/2，面板宽度的一半
    }
    
    const arrowRightLeft = arrowRight.offset().left - mainContainerLeft;
    const arrowRightWidth = arrowRight.width();
    const panelLeft = arrowRightLeft + arrowRightWidth;

    //const panelWidth = $('.language-panel').width() / 2;
    const panelWidth = 289 / 2;
    
    const  pos = panelLeft - panelWidth - arrowRightWidth + 10; //  +10是因为源语言左侧有10px边距，导致页面中心无法对齐箭头

    return  pos;
}

function sendLoginQuest() {
    uploadLog("userLogin", "user click login");
    chrome.runtime.sendMessage({ action: 'user_login' });
}

function calculateArrowPosition() {
    // 语言菜单居中
    let mainWidth = $('#rtvt-main-container').width();
    let middleWidth = 510; // 当610px的时候箭头处于居中位置，后续数值调整的话需要手动调试
  
    let offset = mainWidth - mainMinWidth; 
    if (mainWidth > middleWidth) {
        // 到达中间时，拖拽时两边都需要增加一半的偏移量
        offset = middleWidth - mainMinWidth;
        // 超出middleWidth部分需*0.5
        let tmp = (mainWidth - middleWidth) * 0.5; 
        offset += tmp;
    }

     // 220是主页面最小时, 语言菜单可显示的完整位置，对应css中.rtvt-top-center的left设置
     let arrowMinPos = 230;  

     return arrowMinPos + offset;
}

// 更新language-panel位置
function updateLanguagePanelPosition() {
    // 语言菜单位置
    let pos = calculateArrowPosition();
    $('.rtvt-top-center').css({
        left: pos
    });

    // 语言选择面板位置
    pos = calculateLanguagePanelPosition();
    $('.language-panel').css({
        left: pos
    });
}


function restartAudioCapture() {
    if (isCapture) {
        pauseRecording(tabId, false);
        setTimeout(() => {
            resumeRecording(tabId, false);
        }, 20);
    }
}

function updateSubtitleStyleAccess() {
    const tipElement = $('#rtvt-style-tip');
    if (!tipElement.length) {
        return;
    }

    const colorItems = $('.rtvt-text-color-item');
    const sizeItems = $('.rtvt-text-size-item');
    const opacitySelect = $('#opacity-select');
    const fontSizeSelect = $('#minbeds');
    const strokeRadios = $('input[name="shadow"]');
    const strokeLabels = $('.rtvt-text-shadow label');
    const highlightInput = $('#highlight-check');
    const highlightLabel = $('.highlight-switch');

    if (isLogin) {
        colorItems.removeClass('disabled');
        opacitySelect.prop('disabled', false).removeClass('disabled');
        fontSizeSelect.prop('disabled', false).removeClass('disabled');
        strokeRadios.prop('disabled', false);
        strokeLabels.removeClass('disabled');
        highlightInput.prop('disabled', false);
        highlightLabel.removeClass('disabled');
        sizeItems.removeClass('disabled');
        if (sizeSlider) {
            sizeSlider.slider('enable');
        }
        if (opacitySlider) {
            opacitySlider.slider('enable');
        }
        tipElement.removeClass('clickable').hide();
    } else {
        colorItems.addClass('disabled');
        opacitySelect.prop('disabled', true).addClass('disabled');
        fontSizeSelect.prop('disabled', true).addClass('disabled');
        strokeRadios.prop('disabled', true);
        strokeLabels.addClass('disabled');
        highlightInput.prop('disabled', true);
        highlightLabel.addClass('disabled');
        sizeItems.addClass('disabled');
        if (sizeSlider) {
            sizeSlider.slider('disable');
        }
        if (opacitySlider) {
            opacitySlider.slider('disable');
        }
        tipElement.text(loginToUseStr).addClass('clickable').show();
    }
}

} // 结束 rtvtExtensionLoaded 检查