loadStatus = false;

// Load localized text for normal mode
function loadLocalizedText() {
    const instructionText = document.getElementById("instruction-text");
    const info1 = document.getElementById("info-1");
    const info2 = document.getElementById("info-2");
    
    // 使用 chrome.i18n.getMessage 来支持多语言
    if (instructionText) {
        instructionText.textContent = chrome.i18n.getMessage("popup_instruction_text");
    }
    if (info1) {
        info1.textContent = chrome.i18n.getMessage("popup_info_1");
    }
    if (info2) {
        info2.textContent = chrome.i18n.getMessage("popup_info_2");
    }
}

// Load localized text for video mode
function loadVideoModeText() {
    const startedStatusText = chrome.i18n.getMessage("started_status");
    const startedStatusElement = document.getElementById("started-status");
    if (startedStatusElement && startedStatusText) {
        startedStatusElement.textContent = startedStatusText;
    }
}

// Timer countdown
let countdown = 10;
function startTimer() {
    const timerElement = document.getElementById("timer");
    const interval = setInterval(() => {
        countdown--;
        if (countdown >= 0) {
            timerElement.textContent = countdown + "s";
        }
        if (countdown <= 0) {
            clearInterval(interval);
            window.close();
        }
    }, 1000);
}

// 检测是否为无效页面（非音视频页面）
function checkIfVideoPage(callback) {
    chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
        if (tabs && tabs[0]) {
            const tab = tabs[0];
            const tabId = tab.id;
            const url = tab.url || '';
            
            // 首先检查URL是否为无效页面
            if (isInvalidPageByUrl(url)) {
                callback(false);
                return;
            }
            
            // 如果URL有效，再检测页面是否包含音视频元素
            chrome.scripting.executeScript(
                {
                    target: { tabId },
                    func: () => {
                        // 检测页面是否包含音视频元素
                        // const hasVideo = document.getElementsByTagName('video').length > 0;
                        // const hasAudio = document.getElementsByTagName('audio').length > 0;
                        
                        // // 检查是否存在嵌入的视频
                        // const hasIframe = Array.from(document.getElementsByTagName('iframe')).some(iframe => {
                        //     try {
                        //         return iframe.contentWindow.document.getElementsByTagName('video').length > 0 ||
                        //                iframe.contentWindow.document.getElementsByTagName('audio').length > 0;
                        //     } catch (e) {
                        //         return false;
                        //     }
                        // });
                        // return hasVideo || hasAudio || hasIframe;
                        return true;
                    }
                },
                (results) => {
                    const hasMedia = results && results[0] && results[0].result;
                    callback(hasMedia);
                }
            );
        } else {
            callback(false);
        }
    });
}

// 根据URL判断是否为无效页面
function isInvalidPageByUrl(url) {
    if (!url) return true;
    
    // 检测Chrome内部页面
    if (url.startsWith('chrome://') || 
        url.startsWith('chrome-extension://') || 
        url.startsWith('about:')) {
        return true;
    }
    
    // 检测空标签页
    if (url === 'about:blank' || url === 'chrome://newtab/') {
        return true;
    }
    
    // 检测Chrome商店
    if (url.includes('chrome.google.com/webstore') || 
        url.includes('chromewebstore.google.com')) {
        return true;
    }
    
    // 检测扩展管理页
    if (url.includes('chrome://extensions')) {
        return true;
    }
    
    // 检测Edge浏览器的特殊页面
    if (url.startsWith('edge://') || 
        url.includes('microsoftedge.microsoft.com')) {
        return true;
    }
    
    return false;
}

// 初始化扩展功能
function initializeExtension() {
    // Get the current id
    chrome.tabs.query(
      {
          active: true,
          currentWindow: true,
      },
      (tabs) => {
          const tabId = tabs[0].id;
          // Get the streamId
          chrome.tabCapture.getMediaStreamId(
              {
                  consumerTabId: tabId,
              },
              (streamId) => {

                  if (!loadStatus) {
                    loadStatus = true;
                    // 检查是否已经加载过扩展
                    chrome.scripting.executeScript(
                      {
                          target: { tabId },
                          func: () => {
                              return typeof window.rtvtExtensionLoaded !== 'undefined';
                          }
                      },
                      (results) => {
                          const alreadyLoaded = results && results[0] && results[0].result;
                          
                          if (!alreadyLoaded) {
                              // Load the content.js
                              chrome.scripting.executeScript(
                                {
                                    target: { tabId },
                                    files: ["thirdParty/jquery-3.7.1.min.js", "thirdParty/jquery-ui.min.js", "thirdParty/crypto-js.min.js", "thirdParty/modernizr.custom.js", "thirdParty/dlmenu.min.js", "thirdParty/int64.min.js", "thirdParty/msgpack.min.js", "thirdParty/fpnn.min.js", "thirdParty/rtvt.sdk.js", "content.js"],
                                },
                                () => {
                                    // Send the streamId to the tab
                                    chrome.tabs.sendMessage(tabId, {contentStart: true, streamId: streamId, tabId: tabId});
                                    // 自动关闭 popup，避免“第一次点击用于关闭popup，第二次才生效”的体验
                                    try { window.close(); } catch (e) {}
                                }
                              );
                          } else {
                              // 如果已经加载，直接发送消息
                              chrome.tabs.sendMessage(tabId, {contentStart: true, streamId: streamId, tabId: tabId});
                              // 同上：发送后立即关闭 popup
                              try { window.close(); } catch (e) {}
                          }
                      }
                    );
                  }
              }
          );
      }
    );
}

// 主初始化逻辑
document.addEventListener('DOMContentLoaded', function() {
    // 检测是否为音视频页面
    checkIfVideoPage((isVideoPage) => {
        if (isVideoPage) {
            // 音视频页面：显示简洁模式
            document.documentElement.classList.add('video-mode');
            document.body.classList.add('video-mode');
            loadVideoModeText();

            // 初始化扩展功能
            initializeExtension();
        } else {
            // 非音视频页面：显示正常模式
            loadLocalizedText();
            startTimer();
            
            const closeBtn = document.getElementById("close-btn");
            if (closeBtn) {
                closeBtn.addEventListener('click', function() {
                    window.close();
                });
            }
        }
    });
});
